/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.document.property;

import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.document.property.DefaultingDocProperty;
import eu.cloudnetservice.driver.document.property.DocProperty;
import eu.cloudnetservice.driver.document.property.ReadOnlyDocProperty;
import eu.cloudnetservice.driver.document.property.RewritingDocProperty;
import java.lang.reflect.Type;
import java.util.function.Function;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

record StandardDocProperty<E>(@NonNull String key, @NonNull Type type) implements DocProperty<E>
{
    public StandardDocProperty(@NonNull String key, @NonNull Type type) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
    }

    @Override
    public boolean readOnly() {
        return false;
    }

    @Override
    @NonNull
    public DocProperty<E> asReadOnly() {
        return new ReadOnlyDocProperty(this);
    }

    @Override
    @NonNull
    public DocProperty<E> withDefault(@Nullable E def) {
        return new DefaultingDocProperty<E>(this, def);
    }

    @Override
    @NonNull
    public <V> DocProperty<V> withReadRewrite(@NonNull Function<E, V> rewriteFunction) {
        if (rewriteFunction == null) {
            throw new NullPointerException("rewriteFunction is marked non-null but is null");
        }
        return this.withReadWriteRewrite(rewriteFunction, null);
    }

    @Override
    @NonNull
    public <V> DocProperty<V> withReadWriteRewrite(@NonNull Function<E, V> readRewriteFunction, @Nullable Function<V, E> writeRewriteFunction) {
        if (readRewriteFunction == null) {
            throw new NullPointerException("readRewriteFunction is marked non-null but is null");
        }
        RewritingDocProperty<E, V> rewritingProperty = new RewritingDocProperty<E, V>(this, readRewriteFunction, writeRewriteFunction);
        return writeRewriteFunction == null ? rewritingProperty.asReadOnly() : rewritingProperty;
    }

    @Override
    @Nullable
    public E readFrom(@NonNull Document document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        return (E)document.readObject(this.key, this.type);
    }

    @Override
    @NonNull
    public DocProperty<E> writeTo(@NonNull Document.Mutable document, @Nullable E value) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        document.append(this.key, value);
        return this;
    }
}

