/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.document.property;

import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.document.property.DefaultingDocProperty;
import eu.cloudnetservice.driver.document.property.DocProperty;
import eu.cloudnetservice.driver.document.property.ReadOnlyDocProperty;
import java.util.function.Function;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

record RewritingDocProperty<I, O>(@NonNull DocProperty<I> upstream, @NonNull Function<I, O> readRewriteFunction, @Nullable Function<O, I> writeRewriteFunction) implements DocProperty<O>
{
    public RewritingDocProperty(@NonNull DocProperty<I> upstream, @NonNull Function<I, O> readRewriteFunction, @Nullable Function<O, I> writeRewriteFunction) {
        if (upstream == null) {
            throw new NullPointerException("upstream is marked non-null but is null");
        }
        if (readRewriteFunction == null) {
            throw new NullPointerException("readRewriteFunction is marked non-null but is null");
        }
    }

    @Override
    @NonNull
    public String key() {
        return this.upstream.key();
    }

    @Override
    public boolean readOnly() {
        return false;
    }

    @Override
    @NonNull
    public DocProperty<O> asReadOnly() {
        return new ReadOnlyDocProperty(this);
    }

    @Override
    @NonNull
    public DocProperty<O> withDefault(@Nullable O def) {
        return new DefaultingDocProperty<O>(this, def);
    }

    @Override
    @NonNull
    public <V> DocProperty<V> withReadRewrite(@NonNull Function<O, V> rewriteFunction) {
        if (rewriteFunction == null) {
            throw new NullPointerException("rewriteFunction is marked non-null but is null");
        }
        return this.withReadWriteRewrite(rewriteFunction, (Function<V, O>)null);
    }

    @Override
    @NonNull
    public <V> DocProperty<V> withReadWriteRewrite(@NonNull Function<O, V> readRewriteFunction, @Nullable Function<V, O> writeRewriteFunction) {
        if (readRewriteFunction == null) {
            throw new NullPointerException("readRewriteFunction is marked non-null but is null");
        }
        RewritingDocProperty<O, V> rewritingProperty = new RewritingDocProperty<O, V>(this, readRewriteFunction, writeRewriteFunction);
        return writeRewriteFunction == null ? rewritingProperty.asReadOnly() : rewritingProperty;
    }

    @Override
    @Nullable
    public O readFrom(@NonNull Document document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        I upstreamValue = this.upstream.readFrom(document);
        return upstreamValue == null ? null : (O)this.readRewriteFunction.apply(upstreamValue);
    }

    @Override
    @NonNull
    public DocProperty<O> writeTo(@NonNull Document.Mutable document, @Nullable O value) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        if (this.writeRewriteFunction == null) {
            throw new UnsupportedOperationException("Unable to write property to document - missing write rewrite function");
        }
        if (value == null) {
            this.upstream.writeTo(document, null);
        } else {
            I convertedValue = this.writeRewriteFunction.apply(value);
            this.upstream.writeTo(document, convertedValue);
        }
        return this;
    }
}

