/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.document.property;

import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.document.property.DefaultingDocProperty;
import eu.cloudnetservice.driver.document.property.DocProperty;
import eu.cloudnetservice.driver.document.property.RewritingDocProperty;
import java.util.function.Function;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

record ReadOnlyDocProperty<E>(@NonNull DocProperty<E> downstream) implements DocProperty<E>
{
    public ReadOnlyDocProperty(@NonNull DocProperty<E> downstream) {
        if (downstream == null) {
            throw new NullPointerException("downstream is marked non-null but is null");
        }
    }

    @Override
    @NonNull
    public String key() {
        return this.downstream.key();
    }

    @Override
    public boolean readOnly() {
        return true;
    }

    @Override
    @NonNull
    public DocProperty<E> asReadOnly() {
        return this;
    }

    @Override
    @NonNull
    public DocProperty<E> withDefault(@Nullable E def) {
        DefaultingDocProperty<E> defaultingProperty = new DefaultingDocProperty<E>(this.downstream, def);
        return defaultingProperty.asReadOnly();
    }

    @Override
    @NonNull
    public <V> DocProperty<V> withReadRewrite(@NonNull Function<E, V> rewriteFunction) {
        if (rewriteFunction == null) {
            throw new NullPointerException("rewriteFunction is marked non-null but is null");
        }
        return this.withReadWriteRewrite(rewriteFunction, null);
    }

    @Override
    @NonNull
    public <V> DocProperty<V> withReadWriteRewrite(@NonNull Function<E, V> readRewriteFunction, @Nullable Function<V, E> writeRewriteFunction) {
        if (readRewriteFunction == null) {
            throw new NullPointerException("readRewriteFunction is marked non-null but is null");
        }
        RewritingDocProperty<E, V> rewritingProperty = new RewritingDocProperty<E, V>(this.downstream, readRewriteFunction, null);
        return rewritingProperty.asReadOnly();
    }

    @Override
    @Nullable
    public E readFrom(@NonNull Document document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        return this.downstream.readFrom(document);
    }

    @Override
    @NonNull
    public DocProperty<E> writeTo(@NonNull Document.Mutable document, @Nullable E value) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        throw new UnsupportedOperationException("Property is read-only");
    }
}

