/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.document.gson;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.document.StandardSerialisationStyle;
import eu.cloudnetservice.driver.document.gson.GsonProvider;
import eu.cloudnetservice.driver.document.gson.ImmutableGsonDocument;
import eu.cloudnetservice.driver.document.gson.send.GsonRootObjectVisitor;
import eu.cloudnetservice.driver.document.property.DefaultedDocPropertyHolder;
import eu.cloudnetservice.driver.document.send.DocumentSend;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

final class MutableGsonDocument
extends ImmutableGsonDocument
implements Document.Mutable,
DefaultedDocPropertyHolder.Mutable<Document.Mutable> {
    private static final long serialVersionUID = 4248891600084741117L;

    public MutableGsonDocument() {
        this(new JsonObject());
    }

    MutableGsonDocument(@NonNull JsonObject internalObject) {
        super(internalObject);
        if (internalObject == null) {
            throw new NullPointerException("internalObject is marked non-null but is null");
        }
    }

    @Override
    @NonNull
    public Document.Mutable clear() {
        Set<String> keys = Set.copyOf(this.internalObject.keySet());
        for (String key : keys) {
            this.internalObject.remove(key);
        }
        return this;
    }

    @Override
    @NonNull
    public Document.Mutable remove(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.internalObject.remove(key);
        return this;
    }

    @Override
    @NonNull
    public Document.Mutable receive(@NonNull DocumentSend send) {
        if (send == null) {
            throw new NullPointerException("send is marked non-null but is null");
        }
        GsonRootObjectVisitor visitor = new GsonRootObjectVisitor(this.internalObject);
        send.rootElement().accept(visitor);
        return this;
    }

    @Override
    @NonNull
    public Document.Mutable appendNull(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.internalObject.add(key, (JsonElement)JsonNull.INSTANCE);
        return this;
    }

    @Override
    @NonNull
    public Document.Mutable appendTree(@Nullable Object value) {
        JsonNull element;
        Object object = element = value == null ? JsonNull.INSTANCE : GsonProvider.NORMAL_GSON_INSTANCE.toJsonTree(value);
        if (element.isJsonObject()) {
            JsonObject jsonObject = element.getAsJsonObject();
            for (Map.Entry entry : jsonObject.entrySet()) {
                this.internalObject.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        }
        return this;
    }

    @Override
    @NonNull
    public Document.Mutable append(@NonNull Document document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        DocumentSend documentSend = document.send();
        return this.receive(documentSend);
    }

    @Override
    @NonNull
    public Document.Mutable append(@NonNull String key, @Nullable Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        JsonNull element = value == null ? JsonNull.INSTANCE : GsonProvider.NORMAL_GSON_INSTANCE.toJsonTree(value);
        this.internalObject.add(key, (JsonElement)element);
        return this;
    }

    @Override
    @NonNull
    public Document.Mutable append(@NonNull String key, @Nullable Number value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.internalObject.addProperty(key, value);
        return this;
    }

    @Override
    @NonNull
    public Document.Mutable append(@NonNull String key, @Nullable Boolean value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.internalObject.addProperty(key, value);
        return this;
    }

    @Override
    @NonNull
    public Document.Mutable append(@NonNull String key, @Nullable String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.internalObject.addProperty(key, value);
        return this;
    }

    @Override
    @NonNull
    public Document.Mutable append(@NonNull String key, @Nullable Document value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            this.internalObject.add(key, (JsonElement)JsonNull.INSTANCE);
            return this;
        }
        JsonObject object = new JsonObject();
        this.internalObject.add(key, (JsonElement)object);
        DocumentSend send = value.send();
        GsonRootObjectVisitor visitor = new GsonRootObjectVisitor(object);
        send.rootElement().accept(visitor);
        return this;
    }

    @Override
    @NonNull
    public Document.Mutable propertyHolder() {
        return this;
    }

    private void writeObject(@NonNull ObjectOutputStream out) throws IOException {
        if (out == null) {
            throw new NullPointerException("out is marked non-null but is null");
        }
        out.writeUTF(this.serializeToString(StandardSerialisationStyle.COMPACT));
    }

    private void readObject(@NonNull ObjectInputStream in) throws IOException {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        JsonElement parsedDocument = JsonParser.parseString((String)in.readUTF());
        Preconditions.checkArgument((boolean)parsedDocument.isJsonObject(), (Object)"Input is not a json object");
        JsonObject object = parsedDocument.getAsJsonObject();
        for (Map.Entry entry : object.entrySet()) {
            this.internalObject.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
    }
}

