/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.document.gson;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import eu.cloudnetservice.common.io.FileUtil;
import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.document.DocumentSerialisationException;
import eu.cloudnetservice.driver.document.SerialisationStyle;
import eu.cloudnetservice.driver.document.StandardSerialisationStyle;
import eu.cloudnetservice.driver.document.gson.GsonProvider;
import eu.cloudnetservice.driver.document.gson.MutableGsonDocument;
import eu.cloudnetservice.driver.document.gson.send.GsonDocumentSend;
import eu.cloudnetservice.driver.document.property.DefaultedDocPropertyHolder;
import eu.cloudnetservice.driver.document.send.DocumentSend;
import eu.cloudnetservice.driver.document.send.element.Element;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import io.leangen.geantyref.TypeToken;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.Unmodifiable;

class ImmutableGsonDocument
implements Document,
DefaultedDocPropertyHolder {
    private static final long serialVersionUID = 865904160436074500L;
    protected final JsonObject internalObject;

    public ImmutableGsonDocument() {
        this(new JsonObject());
    }

    ImmutableGsonDocument(@NonNull JsonObject internalObject) {
        if (internalObject == null) {
            throw new NullPointerException("internalObject is marked non-null but is null");
        }
        this.internalObject = internalObject;
    }

    @Override
    @NonNull
    public String factoryName() {
        return "json";
    }

    @Override
    public boolean empty() {
        return this.internalObject.isEmpty();
    }

    @Override
    public int elementCount() {
        return this.internalObject.size();
    }

    @Override
    public boolean contains(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.internalObject.has(key);
    }

    @Override
    @NonNull
    public DocumentSend send() {
        return GsonDocumentSend.fromJsonObject(this.internalObject);
    }

    @Override
    @NonNull
    public Document immutableCopy() {
        JsonObject objectCopy = this.internalObject.deepCopy();
        return new ImmutableGsonDocument(objectCopy);
    }

    @Override
    @NonNull
    public Document.Mutable mutableCopy() {
        JsonObject objectCopy = this.internalObject.deepCopy();
        return new MutableGsonDocument(objectCopy);
    }

    @Override
    public @Unmodifiable @NonNull Set<String> keys() {
        return Set.copyOf(this.internalObject.keySet());
    }

    @Override
    public @Unmodifiable @NonNull Collection<? extends Element> elements() {
        DocumentSend documentSend = this.send();
        return documentSend.rootElement().elements();
    }

    @Override
    public <T> @UnknownNullability T toInstanceOf(@NonNull Type type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return (T)GsonProvider.NORMAL_GSON_INSTANCE.fromJson((JsonElement)this.internalObject, type);
    }

    @Override
    public <T> @UnknownNullability T toInstanceOf(@NonNull Class<T> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return (T)GsonProvider.NORMAL_GSON_INSTANCE.fromJson((JsonElement)this.internalObject, type);
    }

    @Override
    public <T> @UnknownNullability T toInstanceOf(@NonNull TypeToken<T> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.toInstanceOf(type.getType());
    }

    @Override
    public <T> @UnknownNullability T readObject(@NonNull String key, @NonNull Type type, @Nullable T def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        JsonElement objectElement = this.internalObject.get(key);
        return (T)(objectElement == null ? def : GsonProvider.NORMAL_GSON_INSTANCE.fromJson(objectElement, type));
    }

    @Override
    public <T> @UnknownNullability T readObject(@NonNull String key, @NonNull Class<T> type, @Nullable T def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        JsonElement objectElement = this.internalObject.get(key);
        return (T)(objectElement == null ? def : GsonProvider.NORMAL_GSON_INSTANCE.fromJson(objectElement, type));
    }

    @Override
    public <T> @UnknownNullability T readObject(@NonNull String key, @NonNull TypeToken<T> type, @Nullable T def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.readObject(key, type.getType(), def);
    }

    @Override
    public @UnknownNullability Document readDocument(@NonNull String key, @Nullable Document def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        JsonElement documentElement = this.getElementSafe(key);
        if (documentElement.isJsonObject()) {
            JsonObject documentObject = documentElement.getAsJsonObject();
            return new ImmutableGsonDocument(documentObject.deepCopy());
        }
        return def;
    }

    @Override
    public @UnknownNullability Document.Mutable readMutableDocument(@NonNull String key, @Nullable Document.Mutable def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        JsonElement documentElement = this.getElementSafe(key);
        if (documentElement.isJsonObject()) {
            JsonObject documentObject = documentElement.getAsJsonObject();
            return new MutableGsonDocument(documentObject.deepCopy());
        }
        return def;
    }

    @Override
    public byte getByte(@NonNull String key, byte def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        JsonPrimitive primitiveElement = this.getPrimitiveElement(key);
        return primitiveElement != null && primitiveElement.isNumber() ? primitiveElement.getAsByte() : def;
    }

    @Override
    public short getShort(@NonNull String key, short def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        JsonPrimitive primitiveElement = this.getPrimitiveElement(key);
        return primitiveElement != null && primitiveElement.isNumber() ? primitiveElement.getAsShort() : def;
    }

    @Override
    public int getInt(@NonNull String key, int def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        JsonPrimitive primitiveElement = this.getPrimitiveElement(key);
        return primitiveElement != null && primitiveElement.isNumber() ? primitiveElement.getAsInt() : def;
    }

    @Override
    public long getLong(@NonNull String key, long def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        JsonPrimitive primitiveElement = this.getPrimitiveElement(key);
        return primitiveElement != null && primitiveElement.isNumber() ? primitiveElement.getAsLong() : def;
    }

    @Override
    public float getFloat(@NonNull String key, float def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        JsonPrimitive primitiveElement = this.getPrimitiveElement(key);
        return primitiveElement != null && primitiveElement.isNumber() ? primitiveElement.getAsFloat() : def;
    }

    @Override
    public double getDouble(@NonNull String key, double def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        JsonPrimitive primitiveElement = this.getPrimitiveElement(key);
        return primitiveElement != null && primitiveElement.isNumber() ? primitiveElement.getAsDouble() : def;
    }

    @Override
    public boolean getBoolean(@NonNull String key, boolean def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        JsonPrimitive primitiveElement = this.getPrimitiveElement(key);
        return primitiveElement != null && primitiveElement.isBoolean() ? primitiveElement.getAsBoolean() : def;
    }

    @Override
    public @UnknownNullability String getString(@NonNull String key, @Nullable String def) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        JsonPrimitive primitiveElement = this.getPrimitiveElement(key);
        return primitiveElement != null && primitiveElement.isString() ? primitiveElement.getAsString() : def;
    }

    @Nullable
    private JsonPrimitive getPrimitiveElement(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        JsonElement element = this.getElementSafe(key);
        return element.isJsonPrimitive() ? element.getAsJsonPrimitive() : null;
    }

    @NonNull
    private JsonElement getElementSafe(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        JsonElement element = this.internalObject.get(key);
        return (JsonElement)Objects.requireNonNullElse(element, JsonNull.INSTANCE);
    }

    @Override
    public void writeTo(@NonNull Path path, @NonNull SerialisationStyle style) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (style == null) {
            throw new NullPointerException("style is marked non-null but is null");
        }
        FileUtil.createDirectory((Path)path.getParent());
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            this.writeTo(outputStream, style);
        }
        catch (IOException exception) {
            throw new DocumentSerialisationException("Unable to write document to " + path, exception);
        }
    }

    @Override
    public void writeTo(@NonNull OutputStream stream, @NonNull SerialisationStyle style) {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        if (style == null) {
            throw new NullPointerException("style is marked non-null but is null");
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(stream, StandardCharsets.UTF_8);){
            this.writeTo(writer, style);
        }
        catch (IOException exception) {
            throw new DocumentSerialisationException(exception);
        }
    }

    @Override
    public void writeTo(@NonNull Appendable appendable, @NonNull SerialisationStyle style) {
        if (appendable == null) {
            throw new NullPointerException("appendable is marked non-null but is null");
        }
        if (style == null) {
            throw new NullPointerException("style is marked non-null but is null");
        }
        try {
            Gson serialisationGsonInstance = this.resolveSerialisationGsonInstance(style);
            serialisationGsonInstance.toJson((JsonElement)this.internalObject, appendable);
        }
        catch (JsonIOException exception) {
            throw new DocumentSerialisationException(exception);
        }
    }

    @Override
    public void writeTo(@NonNull DataBuf.Mutable dataBuf, @NonNull SerialisationStyle style) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        if (style == null) {
            throw new NullPointerException("style is marked non-null but is null");
        }
        String encodedJson = this.serializeToString(style);
        dataBuf.writeString(encodedJson);
    }

    @Override
    @NonNull
    public String serializeToString(@NonNull SerialisationStyle style) {
        if (style == null) {
            throw new NullPointerException("style is marked non-null but is null");
        }
        try {
            Gson serialisationGsonInstance = this.resolveSerialisationGsonInstance(style);
            return serialisationGsonInstance.toJson((JsonElement)this.internalObject);
        }
        catch (JsonIOException exception) {
            throw new DocumentSerialisationException(exception);
        }
    }

    @NonNull
    private Gson resolveSerialisationGsonInstance(@NonNull SerialisationStyle style) {
        if (style == null) {
            throw new NullPointerException("style is marked non-null but is null");
        }
        if (style == StandardSerialisationStyle.PRETTY) {
            return GsonProvider.PRETTY_PRINTING_GSON_INSTANCE;
        }
        if (style == StandardSerialisationStyle.COMPACT) {
            return GsonProvider.NORMAL_GSON_INSTANCE;
        }
        throw new UnsupportedOperationException("Unsupported serialisation style: " + style);
    }

    @Override
    @NonNull
    public Document propertyHolder() {
        return this;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ImmutableGsonDocument) {
            ImmutableGsonDocument document = (ImmutableGsonDocument)other;
            return Objects.equals(this.internalObject, document.internalObject);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.internalObject);
    }

    @Override
    @NonNull
    public String toString() {
        return this.serializeToString(StandardSerialisationStyle.COMPACT);
    }

    private void writeObject(@NonNull ObjectOutputStream out) throws IOException {
        if (out == null) {
            throw new NullPointerException("out is marked non-null but is null");
        }
        out.writeUTF(this.serializeToString(StandardSerialisationStyle.COMPACT));
    }

    private void readObject(@NonNull ObjectInputStream in) throws IOException {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        JsonElement parsedDocument = JsonParser.parseString((String)in.readUTF());
        Preconditions.checkArgument((boolean)parsedDocument.isJsonObject(), (Object)"Input is not a json object");
        JsonObject object = parsedDocument.getAsJsonObject();
        for (Map.Entry entry : object.entrySet()) {
            this.internalObject.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
    }
}

