/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.document.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import eu.cloudnetservice.driver.document.annotations.DocumentValueIgnore;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

final class GsonDocumentExclusionStrategy
implements ExclusionStrategy {
    public static final GsonDocumentExclusionStrategy SERIALIZE = new GsonDocumentExclusionStrategy(DocumentValueIgnore.Direction.SERIALIZE);
    public static final GsonDocumentExclusionStrategy DESERIALIZE = new GsonDocumentExclusionStrategy(DocumentValueIgnore.Direction.DESERIALIZE);
    private final DocumentValueIgnore.Direction direction;

    private GsonDocumentExclusionStrategy(@NonNull DocumentValueIgnore.Direction direction) {
        if (direction == null) {
            throw new NullPointerException("direction is marked non-null but is null");
        }
        this.direction = direction;
    }

    public boolean shouldSkipField(@NonNull FieldAttributes field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        DocumentValueIgnore ignoreAnnotation = (DocumentValueIgnore)field.getAnnotation(DocumentValueIgnore.class);
        return this.shouldExclude(ignoreAnnotation);
    }

    public boolean shouldSkipClass(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        DocumentValueIgnore ignoreAnnotation = clazz.getAnnotation(DocumentValueIgnore.class);
        return this.shouldExclude(ignoreAnnotation);
    }

    private boolean shouldExclude(@Nullable DocumentValueIgnore ignoreAnnotation) {
        DocumentValueIgnore.Direction[] directions;
        if (ignoreAnnotation == null) {
            return false;
        }
        for (DocumentValueIgnore.Direction excludedDirection : directions = ignoreAnnotation.value()) {
            if (excludedDirection != this.direction) continue;
            return true;
        }
        return false;
    }
}

