/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.document.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

record DelegateTypeAdapterFactory(@NonNull Predicate<Class<?>> typeSupportChecker, @NonNull Function<Gson, TypeAdapter<?>> delegateFactory) implements TypeAdapterFactory
{
    public DelegateTypeAdapterFactory(@NonNull Predicate<Class<?>> typeSupportChecker, @NonNull Function<Gson, TypeAdapter<?>> delegateFactory) {
        if (typeSupportChecker == null) {
            throw new NullPointerException("typeSupportChecker is marked non-null but is null");
        }
        if (delegateFactory == null) {
            throw new NullPointerException("delegateFactory is marked non-null but is null");
        }
    }

    @NonNull
    public static TypeAdapterFactory standardFactory(@NonNull Class<?> baseClass, @NonNull Function<Gson, TypeAdapter<?>> delegateFactory) {
        if (baseClass == null) {
            throw new NullPointerException("baseClass is marked non-null but is null");
        }
        if (delegateFactory == null) {
            throw new NullPointerException("delegateFactory is marked non-null but is null");
        }
        return new DelegateTypeAdapterFactory(baseClass::equals, delegateFactory);
    }

    @NonNull
    public static TypeAdapterFactory hierarchyFactory(@NonNull Class<?> baseClass, @NonNull Function<Gson, TypeAdapter<?>> delegateFactory) {
        if (baseClass == null) {
            throw new NullPointerException("baseClass is marked non-null but is null");
        }
        if (delegateFactory == null) {
            throw new NullPointerException("delegateFactory is marked non-null but is null");
        }
        return new DelegateTypeAdapterFactory(baseClass::isAssignableFrom, delegateFactory);
    }

    @Nullable
    public <T> TypeAdapter<T> create(@NonNull Gson gson, @NonNull TypeToken<T> type) {
        if (gson == null) {
            throw new NullPointerException("gson is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        Class requestedType = type.getRawType();
        if (this.typeSupportChecker.test(requestedType)) {
            return this.delegateFactory.apply(gson);
        }
        return null;
    }
}

