/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.document.defaults;

import dev.derklaro.aerogel.auto.Provides;
import eu.cloudnetservice.driver.document.DocumentFactory;
import eu.cloudnetservice.driver.document.DocumentFactoryRegistry;
import eu.cloudnetservice.driver.document.empty.EmptyDocumentFactory;
import eu.cloudnetservice.driver.document.gson.GsonDocumentFactory;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

@Singleton
@Provides(value={DocumentFactoryRegistry.class})
final class DefaultDocumentFactoryRegistry
implements DocumentFactoryRegistry {
    private final Map<String, DocumentFactory> registeredFactories = new ConcurrentHashMap<String, DocumentFactory>(4, 0.9f, 1);

    private DefaultDocumentFactoryRegistry() {
        this.registeredFactories.put("json", GsonDocumentFactory.INSTANCE);
        this.registeredFactories.put("empty", EmptyDocumentFactory.INSTANCE);
    }

    @Override
    public @UnmodifiableView @NonNull Collection<DocumentFactory> documentFactories() {
        return Collections.unmodifiableCollection(this.registeredFactories.values());
    }

    @Override
    @NonNull
    public DocumentFactory documentFactory(@NonNull String formatName) {
        if (formatName == null) {
            throw new NullPointerException("formatName is marked non-null but is null");
        }
        DocumentFactory factory = this.registeredFactories.get(formatName);
        return Objects.requireNonNull(factory, "no factory with the format name " + formatName + " registered");
    }

    @Override
    @Nullable
    public DocumentFactory findDocumentFactory(@NonNull String formatName) {
        if (formatName == null) {
            throw new NullPointerException("formatName is marked non-null but is null");
        }
        return this.registeredFactories.get(formatName);
    }

    @Override
    @Nullable
    public DocumentFactory unregisterDocumentFactory(@NonNull String formatName) {
        if (formatName == null) {
            throw new NullPointerException("formatName is marked non-null but is null");
        }
        return this.registeredFactories.remove(formatName);
    }

    @Override
    public void registerDocumentFactory(@NonNull DocumentFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        this.registeredFactories.putIfAbsent(factory.formatName(), factory);
    }

    @Override
    @Nullable
    public DocumentFactory replaceDocumentFactory(@NonNull DocumentFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        return this.registeredFactories.put(factory.formatName(), factory);
    }
}

