/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.database;

import eu.cloudnetservice.common.concurrent.Task;
import eu.cloudnetservice.driver.database.Database;
import eu.cloudnetservice.driver.network.rpc.annotation.RPCValidation;
import java.util.Collection;
import lombok.NonNull;

@RPCValidation
public interface DatabaseProvider {
    @NonNull
    public Database database(@NonNull String var1);

    public boolean containsDatabase(@NonNull String var1);

    public boolean deleteDatabase(@NonNull String var1);

    @NonNull
    public Collection<String> databaseNames();

    @NonNull
    default public Task<Boolean> containsDatabaseAsync(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Task.supply(() -> this.containsDatabase(name));
    }

    @NonNull
    default public Task<Boolean> deleteDatabaseAsync(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Task.supply(() -> this.deleteDatabase(name));
    }

    @NonNull
    default public Task<Collection<String>> databaseNamesAsync() {
        return Task.supply(this::databaseNames);
    }
}

