/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.command;

import eu.cloudnetservice.common.Named;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public record CommandInfo(@NonNull String name, @NonNull Set<String> aliases, @NonNull String permission, @NonNull String description, @Nullable String docsUrl, @NonNull List<String> usage) implements Named
{
    public CommandInfo(@NonNull String name, @NonNull Set<String> aliases, @NonNull String permission, @NonNull String description, @Nullable String docsUrl, @NonNull List<String> usage) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (aliases == null) {
            throw new NullPointerException("aliases is marked non-null but is null");
        }
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (usage == null) {
            throw new NullPointerException("usage is marked non-null but is null");
        }
    }

    @NonNull
    public String joinNameToAliases(@NonNull String separator) {
        if (separator == null) {
            throw new NullPointerException("separator is marked non-null but is null");
        }
        Object result = this.name;
        if (!this.aliases.isEmpty()) {
            result = (String)result + separator + String.join((CharSequence)separator, this.aliases);
        }
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CommandInfo)) {
            return false;
        }
        CommandInfo that = (CommandInfo)other;
        return this.name.equals(that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name);
    }
}

