/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver;

import eu.cloudnetservice.common.Named;
import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.document.property.DefaultedDocPropertyHolder;
import lombok.NonNull;

public final class DriverEnvironment
implements DefaultedDocPropertyHolder,
Named {
    public static final DriverEnvironment NODE = new DriverEnvironment("node", Document.emptyDocument());
    public static final DriverEnvironment WRAPPER = new DriverEnvironment("wrapper", Document.emptyDocument());
    private final String name;
    private final Document properties;

    public DriverEnvironment(@NonNull String name, @NonNull Document properties) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.name = name;
        this.properties = properties;
    }

    @NonNull
    public String name() {
        return this.name;
    }

    @Override
    @NonNull
    public Document propertyHolder() {
        return this.properties;
    }

    public String toString() {
        return "DriverEnvironment(name=" + this.name + ", properties=" + this.properties + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DriverEnvironment)) {
            return false;
        }
        DriverEnvironment other = (DriverEnvironment)o;
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Document this$properties = this.properties;
        Document other$properties = other.properties;
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Document $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        return result;
    }
}

