/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.util.asm;

import com.google.common.primitives.Primitives;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

@ApiStatus.Internal
public final class AsmHelper {
    private AsmHelper() {
        throw new UnsupportedOperationException();
    }

    public static void pushInt(@NonNull MethodVisitor mv, int value) {
        if (mv == null) {
            throw new NullPointerException("mv is marked non-null but is null");
        }
        if (value < -1) {
            mv.visitLdcInsn((Object)value);
        } else if (value <= 5) {
            mv.visitInsn(3 + value);
        } else if (value <= 127) {
            mv.visitIntInsn(16, value);
        } else if (value <= Short.MAX_VALUE) {
            mv.visitIntInsn(17, value);
        } else {
            mv.visitLdcInsn((Object)value);
        }
    }

    public static void wrapperToPrimitive(@NonNull MethodVisitor mv, @NonNull Class<?> primitiveType) {
        if (mv == null) {
            throw new NullPointerException("mv is marked non-null but is null");
        }
        if (primitiveType == null) {
            throw new NullPointerException("primitiveType is marked non-null but is null");
        }
        Class wrapper = Primitives.wrap(primitiveType);
        mv.visitTypeInsn(192, Type.getInternalName((Class)wrapper));
        mv.visitMethodInsn(182, Type.getInternalName((Class)wrapper), primitiveType.getSimpleName() + "Value", Type.getMethodDescriptor((Type)Type.getType(primitiveType), (Type[])new Type[0]), false);
    }

    public static void primitiveToWrapper(@NonNull MethodVisitor mv, @NonNull Class<?> primitiveType) {
        if (mv == null) {
            throw new NullPointerException("mv is marked non-null but is null");
        }
        if (primitiveType == null) {
            throw new NullPointerException("primitiveType is marked non-null but is null");
        }
        Class wrapper = Primitives.wrap(primitiveType);
        mv.visitMethodInsn(184, Type.getInternalName((Class)wrapper), "valueOf", Type.getMethodDescriptor((Type)Type.getType((Class)wrapper), (Type[])new Type[]{Type.getType(primitiveType)}), false);
    }
}

