/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.template.defaults;

import eu.cloudnetservice.common.io.FileUtil;
import eu.cloudnetservice.common.io.ZipUtil;
import eu.cloudnetservice.common.stream.ListeningOutputStream;
import eu.cloudnetservice.driver.ComponentInfo;
import eu.cloudnetservice.driver.channel.ChannelMessage;
import eu.cloudnetservice.driver.network.NetworkClient;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.chunk.ChunkedPacketSender;
import eu.cloudnetservice.driver.network.chunk.TransferStatus;
import eu.cloudnetservice.driver.service.ServiceTemplate;
import eu.cloudnetservice.driver.template.TemplateStorage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteTemplateStorage
implements TemplateStorage {
    private final String name;
    private final ComponentInfo componentInfo;
    private final NetworkClient networkClient;

    public RemoteTemplateStorage(@NonNull String name, @NonNull ComponentInfo componentInfo, @NonNull NetworkClient networkClient) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (componentInfo == null) {
            throw new NullPointerException("componentInfo is marked non-null but is null");
        }
        if (networkClient == null) {
            throw new NullPointerException("networkClient is marked non-null but is null");
        }
        this.name = name;
        this.componentInfo = componentInfo;
        this.networkClient = networkClient;
    }

    @NonNull
    public String name() {
        return this.name;
    }

    @Override
    public boolean deployDirectory(@NonNull ServiceTemplate target, @NonNull Path directory, @Nullable Predicate<Path> filter) {
        boolean bl;
        block10: {
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            if (directory == null) {
                throw new NullPointerException("directory is marked non-null but is null");
            }
            InputStream inputStream = ZipUtil.zipToStream((Path)directory, filter);
            try {
                bl = this.deploy(target, inputStream);
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    return false;
                }
            }
            inputStream.close();
        }
        return bl;
    }

    @Override
    public boolean deploy(@NonNull ServiceTemplate target, @NonNull InputStream inputStream) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        return ChunkedPacketSender.forFileTransfer().source(inputStream).transferChannel("deploy_service_template").withExtraData(DataBuf.empty().writeString(this.name).writeObject(target).writeBoolean(true)).toChannels(this.networkClient.firstChannel()).build().transferChunkedData().get(5L, TimeUnit.MINUTES, (Object)TransferStatus.FAILURE) == TransferStatus.SUCCESS;
    }

    @Override
    @Nullable
    public InputStream zipTemplate(@NonNull ServiceTemplate template) throws IOException {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        UUID responseId = UUID.randomUUID();
        ChannelMessage response = ChannelMessage.builder().message("remote_templates_zip_template").channel("cloudnet:internal").targetNode(this.componentInfo.nodeUniqueId()).buffer(DataBuf.empty().writeString(this.name).writeObject(template).writeUniqueId(responseId)).build().sendSingleQuery();
        if (response == null || !response.content().readBoolean()) {
            return null;
        }
        return Files.newInputStream(FileUtil.TEMP_DIR.resolve(responseId.toString()), StandardOpenOption.DELETE_ON_CLOSE);
    }

    @Override
    @NonNull
    public OutputStream appendOutputStream(@NonNull ServiceTemplate template, @NonNull String path) throws IOException {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.openLocalOutputStream(template, path, FileUtil.createTempFile(), true);
    }

    @Override
    @NonNull
    public OutputStream newOutputStream(@NonNull ServiceTemplate template, @NonNull String path) throws IOException {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.openLocalOutputStream(template, path, FileUtil.createTempFile(), false);
    }

    @NonNull
    private OutputStream openLocalOutputStream(@NonNull ServiceTemplate template, @NonNull String path, @NonNull Path localPath, boolean append) throws IOException {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (localPath == null) {
            throw new NullPointerException("localPath is marked non-null but is null");
        }
        return new ListeningOutputStream(Files.newOutputStream(localPath, new OpenOption[0]), $ -> ChunkedPacketSender.forFileTransfer().forFile(localPath).transferChannel("deploy_single_file").toChannels(this.networkClient.firstChannel()).withExtraData(DataBuf.empty().writeString(this.name).writeObject(template).writeString(path).writeBoolean(append)).build().transferChunkedData().get(5L, TimeUnit.MINUTES, null));
    }

    @Override
    @Nullable
    public InputStream newInputStream(@NonNull ServiceTemplate template, @NonNull String path) throws IOException {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        UUID responseId = UUID.randomUUID();
        ChannelMessage response = ChannelMessage.builder().message("remote_templates_template_file").channel("cloudnet:internal").targetNode(this.componentInfo.nodeUniqueId()).buffer(DataBuf.empty().writeString(path).writeString(this.name).writeObject(template).writeUniqueId(responseId)).build().sendSingleQuery();
        if (response == null || !response.content().readBoolean()) {
            return null;
        }
        return Files.newInputStream(FileUtil.TEMP_DIR.resolve(responseId.toString()), StandardOpenOption.DELETE_ON_CLOSE);
    }
}

