/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.service;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.common.Nameable;
import eu.cloudnetservice.driver.inject.InjectionLayer;
import eu.cloudnetservice.driver.template.TemplateStorage;
import eu.cloudnetservice.driver.template.TemplateStorageProvider;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class ServiceTemplate
implements Nameable,
Comparable<ServiceTemplate>,
Cloneable {
    public static final String LOCAL_STORAGE = "local";
    private final String prefix;
    private final String name;
    private final String storage;
    private final int priority;
    private final boolean alwaysCopyToStaticServices;

    protected ServiceTemplate(@NonNull String prefix, @NonNull String name, @NonNull String storage, int priority, boolean alwaysCopyToStaticServices) {
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (storage == null) {
            throw new NullPointerException("storage is marked non-null but is null");
        }
        this.prefix = prefix;
        this.name = name;
        this.storage = storage;
        this.priority = priority;
        this.alwaysCopyToStaticServices = alwaysCopyToStaticServices;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public static Builder builder(@NonNull ServiceTemplate template) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        return ServiceTemplate.builder().name(template.name()).prefix(template.prefix()).storage(template.storageName()).priority(template.priority()).alwaysCopyToStaticServices(template.alwaysCopyToStaticServices());
    }

    @Nullable
    public static ServiceTemplate parse(@NonNull String template) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        String[] parts = template.split(":");
        if (parts.length == 0 || parts.length > 2) {
            return null;
        }
        String path = parts.length == 2 ? parts[1] : parts[0];
        String storage = parts.length == 2 ? parts[0] : LOCAL_STORAGE;
        String[] splitPath = path.split("/");
        if (splitPath.length != 2) {
            return null;
        }
        return ServiceTemplate.builder().prefix(splitPath[0]).name(splitPath[1]).storage(storage).build();
    }

    @NonNull
    public String name() {
        return this.name;
    }

    @NonNull
    public String prefix() {
        return this.prefix;
    }

    @NonNull
    public String storageName() {
        return this.storage;
    }

    public int priority() {
        return this.priority;
    }

    public boolean alwaysCopyToStaticServices() {
        return this.alwaysCopyToStaticServices;
    }

    @NonNull
    public String fullName() {
        return this.prefix + "/" + this.name;
    }

    @NonNull
    public String toString() {
        return this.storage + ":" + this.prefix + "/" + this.name;
    }

    @NonNull
    public TemplateStorage storage() {
        TemplateStorage storage = this.findStorage();
        Preconditions.checkNotNull((Object)storage, (Object)"the storage of this template does not exist");
        return storage;
    }

    @Nullable
    public TemplateStorage findStorage() {
        TemplateStorageProvider storageProvider = InjectionLayer.boot().instance(TemplateStorageProvider.class);
        return storageProvider.templateStorage(this.storage);
    }

    @Override
    public @Range(from=-1L, to=1L) int compareTo(@NonNull ServiceTemplate serviceTemplate) {
        if (serviceTemplate == null) {
            throw new NullPointerException("serviceTemplate is marked non-null but is null");
        }
        return Integer.compare(this.priority, serviceTemplate.priority);
    }

    public ServiceTemplate clone() {
        try {
            return (ServiceTemplate)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new IllegalStateException();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceTemplate)) {
            return false;
        }
        ServiceTemplate other = (ServiceTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.alwaysCopyToStaticServices != other.alwaysCopyToStaticServices) {
            return false;
        }
        String this$prefix = this.prefix;
        String other$prefix = other.prefix;
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$storage = this.storage;
        String other$storage = other.storage;
        return !(this$storage == null ? other$storage != null : !this$storage.equals(other$storage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.priority;
        result = result * 59 + (this.alwaysCopyToStaticServices ? 79 : 97);
        String $prefix = this.prefix;
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        return result;
    }

    public static class Builder {
        private String name;
        private String prefix;
        private String storage = "local";
        private int priority;
        private boolean alwaysCopyToStaticServices;

        @NonNull
        public Builder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @NonNull
        public Builder prefix(@NonNull String prefix) {
            if (prefix == null) {
                throw new NullPointerException("prefix is marked non-null but is null");
            }
            this.prefix = prefix;
            return this;
        }

        @NonNull
        public Builder storage(@NonNull String storage) {
            if (storage == null) {
                throw new NullPointerException("storage is marked non-null but is null");
            }
            this.storage = storage;
            return this;
        }

        @NonNull
        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        @NonNull
        public Builder alwaysCopyToStaticServices(boolean alwaysCopyToStaticServices) {
            this.alwaysCopyToStaticServices = alwaysCopyToStaticServices;
            return this;
        }

        @NonNull
        public ServiceTemplate build() {
            Preconditions.checkNotNull((Object)this.name, (Object)"no name given");
            Preconditions.checkNotNull((Object)this.prefix, (Object)"no prefix given");
            return new ServiceTemplate(this.prefix, this.name, this.storage, this.priority, this.alwaysCopyToStaticServices);
        }
    }
}

