/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.service;

import com.google.common.collect.ComparisonChain;
import eu.cloudnetservice.common.Nameable;
import eu.cloudnetservice.common.document.gson.JsonDocument;
import eu.cloudnetservice.common.document.property.DefaultedDocPropertyHolder;
import eu.cloudnetservice.driver.inject.InjectionLayer;
import eu.cloudnetservice.driver.network.HostAndPort;
import eu.cloudnetservice.driver.provider.CloudServiceProvider;
import eu.cloudnetservice.driver.provider.SpecificCloudServiceProvider;
import eu.cloudnetservice.driver.service.ProcessSnapshot;
import eu.cloudnetservice.driver.service.ServiceConfiguration;
import eu.cloudnetservice.driver.service.ServiceId;
import eu.cloudnetservice.driver.service.ServiceLifeCycle;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

public class ServiceInfoSnapshot
implements Nameable,
DefaultedDocPropertyHolder<JsonDocument, ServiceInfoSnapshot>,
Cloneable,
Comparable<ServiceInfoSnapshot> {
    protected final long creationTime;
    protected final HostAndPort address;
    protected final ProcessSnapshot processSnapshot;
    protected final ServiceConfiguration configuration;
    protected final long connectedTime;
    protected final ServiceLifeCycle lifeCycle;
    protected final JsonDocument properties;

    @ApiStatus.Internal
    public ServiceInfoSnapshot(long creationTime, @NonNull HostAndPort address, @NonNull ProcessSnapshot processSnapshot, @NonNull ServiceConfiguration configuration, long connectedTime, @NonNull ServiceLifeCycle lifeCycle, @NonNull JsonDocument properties) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (processSnapshot == null) {
            throw new NullPointerException("processSnapshot is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (lifeCycle == null) {
            throw new NullPointerException("lifeCycle is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.creationTime = creationTime;
        this.connectedTime = connectedTime;
        this.address = address;
        this.lifeCycle = lifeCycle;
        this.processSnapshot = processSnapshot;
        this.configuration = configuration;
        this.properties = properties;
    }

    public long creationTime() {
        return this.creationTime;
    }

    @NonNull
    public ServiceId serviceId() {
        return this.configuration.serviceId();
    }

    @NonNull
    public HostAndPort address() {
        return this.address;
    }

    public boolean connected() {
        return this.connectedTime != -1L;
    }

    public long connectedTime() {
        return this.connectedTime;
    }

    @NonNull
    public ServiceLifeCycle lifeCycle() {
        return this.lifeCycle;
    }

    @NonNull
    public ProcessSnapshot processSnapshot() {
        return this.processSnapshot;
    }

    @NonNull
    public ServiceConfiguration configuration() {
        return this.configuration;
    }

    @NonNull
    public SpecificCloudServiceProvider provider() {
        CloudServiceProvider serviceProvider = InjectionLayer.boot().instance(CloudServiceProvider.class);
        return serviceProvider.serviceProvider(this.serviceId().uniqueId());
    }

    @NonNull
    public String name() {
        return this.serviceId().name();
    }

    @NonNull
    public JsonDocument propertyHolder() {
        return this.properties;
    }

    @Override
    public int compareTo(@NonNull ServiceInfoSnapshot serviceInfoSnapshot) {
        if (serviceInfoSnapshot == null) {
            throw new NullPointerException("serviceInfoSnapshot is marked non-null but is null");
        }
        return ComparisonChain.start().compare((Comparable)((Object)this.serviceId().taskName()), (Comparable)((Object)serviceInfoSnapshot.serviceId().taskName())).compare(this.serviceId().taskServiceId(), serviceInfoSnapshot.serviceId().taskServiceId()).result();
    }

    @NonNull
    public ServiceInfoSnapshot clone() {
        try {
            return (ServiceInfoSnapshot)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new IllegalStateException();
        }
    }

    public String toString() {
        return "ServiceInfoSnapshot(creationTime=" + this.creationTime + ", address=" + this.address + ", processSnapshot=" + this.processSnapshot + ", configuration=" + this.configuration + ", connectedTime=" + this.connectedTime + ", lifeCycle=" + this.lifeCycle + ", properties=" + this.properties + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceInfoSnapshot)) {
            return false;
        }
        ServiceInfoSnapshot other = (ServiceInfoSnapshot)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.creationTime != other.creationTime) {
            return false;
        }
        if (this.connectedTime != other.connectedTime) {
            return false;
        }
        HostAndPort this$address = this.address;
        HostAndPort other$address = other.address;
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        ProcessSnapshot this$processSnapshot = this.processSnapshot;
        ProcessSnapshot other$processSnapshot = other.processSnapshot;
        if (this$processSnapshot == null ? other$processSnapshot != null : !((Object)this$processSnapshot).equals(other$processSnapshot)) {
            return false;
        }
        ServiceConfiguration this$configuration = this.configuration;
        ServiceConfiguration other$configuration = other.configuration;
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        ServiceLifeCycle this$lifeCycle = this.lifeCycle;
        ServiceLifeCycle other$lifeCycle = other.lifeCycle;
        if (this$lifeCycle == null ? other$lifeCycle != null : !((Object)((Object)this$lifeCycle)).equals((Object)other$lifeCycle)) {
            return false;
        }
        JsonDocument this$properties = this.properties;
        JsonDocument other$properties = other.properties;
        return !(this$properties == null ? other$properties != null : !this$properties.equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceInfoSnapshot;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $creationTime = this.creationTime;
        result = result * 59 + (int)($creationTime >>> 32 ^ $creationTime);
        long $connectedTime = this.connectedTime;
        result = result * 59 + (int)($connectedTime >>> 32 ^ $connectedTime);
        HostAndPort $address = this.address;
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        ProcessSnapshot $processSnapshot = this.processSnapshot;
        result = result * 59 + ($processSnapshot == null ? 43 : ((Object)$processSnapshot).hashCode());
        ServiceConfiguration $configuration = this.configuration;
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        ServiceLifeCycle $lifeCycle = this.lifeCycle;
        result = result * 59 + ($lifeCycle == null ? 43 : ((Object)((Object)$lifeCycle)).hashCode());
        JsonDocument $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        return result;
    }
}

