/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.service;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.common.Nameable;
import eu.cloudnetservice.driver.service.ServiceEnvironmentType;
import eu.cloudnetservice.driver.service.ServiceTask;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.Unmodifiable;

public class ServiceId
implements Nameable {
    protected final String taskName;
    protected final String nameSplitter;
    protected final Set<String> allowedNodes;
    protected final UUID uniqueId;
    protected final int taskServiceId;
    protected final String nodeUniqueId;
    protected final String environmentName;
    protected final ServiceEnvironmentType environment;

    protected ServiceId(@NonNull String taskName, @NonNull String nameSplitter, @NonNull Set<String> allowedNodes, @NonNull UUID uniqueId, int taskServiceId, @Nullable String nodeUniqueId, @NonNull String environmentName, @Nullable ServiceEnvironmentType environment) {
        if (taskName == null) {
            throw new NullPointerException("taskName is marked non-null but is null");
        }
        if (nameSplitter == null) {
            throw new NullPointerException("nameSplitter is marked non-null but is null");
        }
        if (allowedNodes == null) {
            throw new NullPointerException("allowedNodes is marked non-null but is null");
        }
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        if (environmentName == null) {
            throw new NullPointerException("environmentName is marked non-null but is null");
        }
        this.uniqueId = uniqueId;
        this.taskName = taskName;
        this.nameSplitter = nameSplitter;
        this.taskServiceId = taskServiceId;
        this.nodeUniqueId = nodeUniqueId;
        this.allowedNodes = allowedNodes;
        this.environmentName = environmentName;
        this.environment = environment;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public static Builder builder(@NonNull ServiceId serviceId) {
        if (serviceId == null) {
            throw new NullPointerException("serviceId is marked non-null but is null");
        }
        return ServiceId.builder().uniqueId(serviceId.uniqueId()).taskName(serviceId.taskName()).nameSplitter(serviceId.nameSplitter()).environment(serviceId.environmentName()).environment(serviceId.environment()).taskServiceId(serviceId.taskServiceId()).nodeUniqueId(serviceId.nodeUniqueId()).allowedNodes(serviceId.allowedNodes());
    }

    @NonNull
    public String name() {
        return this.taskName + this.nameSplitter + this.taskServiceId;
    }

    @NonNull
    public UUID uniqueId() {
        return this.uniqueId;
    }

    public @UnknownNullability String nodeUniqueId() {
        return this.nodeUniqueId;
    }

    public @Unmodifiable @NonNull Collection<String> allowedNodes() {
        return this.allowedNodes;
    }

    @NonNull
    public String taskName() {
        return this.taskName;
    }

    @NonNull
    public String nameSplitter() {
        return this.nameSplitter;
    }

    @NonNull
    public String environmentName() {
        return this.environmentName;
    }

    public int taskServiceId() {
        return this.taskServiceId;
    }

    public @UnknownNullability ServiceEnvironmentType environment() {
        return this.environment;
    }

    public String toString() {
        return this.name() + ":" + this.uniqueId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceId)) {
            return false;
        }
        ServiceId other = (ServiceId)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.taskServiceId != other.taskServiceId) {
            return false;
        }
        String this$taskName = this.taskName;
        String other$taskName = other.taskName;
        if (this$taskName == null ? other$taskName != null : !this$taskName.equals(other$taskName)) {
            return false;
        }
        String this$nameSplitter = this.nameSplitter;
        String other$nameSplitter = other.nameSplitter;
        if (this$nameSplitter == null ? other$nameSplitter != null : !this$nameSplitter.equals(other$nameSplitter)) {
            return false;
        }
        Set<String> this$allowedNodes = this.allowedNodes;
        Set<String> other$allowedNodes = other.allowedNodes;
        if (this$allowedNodes == null ? other$allowedNodes != null : !((Object)this$allowedNodes).equals(other$allowedNodes)) {
            return false;
        }
        UUID this$uniqueId = this.uniqueId;
        UUID other$uniqueId = other.uniqueId;
        if (this$uniqueId == null ? other$uniqueId != null : !((Object)this$uniqueId).equals(other$uniqueId)) {
            return false;
        }
        String this$nodeUniqueId = this.nodeUniqueId;
        String other$nodeUniqueId = other.nodeUniqueId;
        if (this$nodeUniqueId == null ? other$nodeUniqueId != null : !this$nodeUniqueId.equals(other$nodeUniqueId)) {
            return false;
        }
        String this$environmentName = this.environmentName;
        String other$environmentName = other.environmentName;
        if (this$environmentName == null ? other$environmentName != null : !this$environmentName.equals(other$environmentName)) {
            return false;
        }
        ServiceEnvironmentType this$environment = this.environment;
        ServiceEnvironmentType other$environment = other.environment;
        return !(this$environment == null ? other$environment != null : !((Object)this$environment).equals(other$environment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceId;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.taskServiceId;
        String $taskName = this.taskName;
        result = result * 59 + ($taskName == null ? 43 : $taskName.hashCode());
        String $nameSplitter = this.nameSplitter;
        result = result * 59 + ($nameSplitter == null ? 43 : $nameSplitter.hashCode());
        Set<String> $allowedNodes = this.allowedNodes;
        result = result * 59 + ($allowedNodes == null ? 43 : ((Object)$allowedNodes).hashCode());
        UUID $uniqueId = this.uniqueId;
        result = result * 59 + ($uniqueId == null ? 43 : ((Object)$uniqueId).hashCode());
        String $nodeUniqueId = this.nodeUniqueId;
        result = result * 59 + ($nodeUniqueId == null ? 43 : $nodeUniqueId.hashCode());
        String $environmentName = this.environmentName;
        result = result * 59 + ($environmentName == null ? 43 : $environmentName.hashCode());
        ServiceEnvironmentType $environment = this.environment;
        result = result * 59 + ($environment == null ? 43 : ((Object)$environment).hashCode());
        return result;
    }

    public static class Builder {
        protected UUID uniqueId = UUID.randomUUID();
        protected String taskName;
        protected int taskServiceId = -1;
        protected String nodeUniqueId;
        protected String environmentName;
        protected String nameSplitter = "-";
        protected ServiceEnvironmentType environment;
        protected Set<String> allowedNodes = new HashSet<String>();

        @NonNull
        public Builder uniqueId(@NonNull UUID uniqueId) {
            if (uniqueId == null) {
                throw new NullPointerException("uniqueId is marked non-null but is null");
            }
            this.uniqueId = uniqueId;
            return this;
        }

        @NonNull
        public Builder taskName(@NonNull String taskName) {
            if (taskName == null) {
                throw new NullPointerException("taskName is marked non-null but is null");
            }
            Preconditions.checkArgument((boolean)ServiceTask.NAMING_PATTERN.matcher(taskName).matches(), (Object)"Invalid task name given");
            this.taskName = taskName;
            return this;
        }

        @NonNull
        public Builder taskServiceId(int taskServiceId) {
            this.taskServiceId = taskServiceId;
            return this;
        }

        @NonNull
        public Builder nodeUniqueId(@Nullable String nodeUniqueId) {
            this.nodeUniqueId = nodeUniqueId;
            return this;
        }

        @NonNull
        public Builder nameSplitter(@NonNull String nameSplitter) {
            if (nameSplitter == null) {
                throw new NullPointerException("nameSplitter is marked non-null but is null");
            }
            Preconditions.checkArgument((boolean)ServiceTask.NAMING_PATTERN.matcher(nameSplitter).matches(), (Object)"Invalid name splitter given");
            this.nameSplitter = nameSplitter;
            return this;
        }

        @NonNull
        public Builder environment(@NonNull String environmentName) {
            if (environmentName == null) {
                throw new NullPointerException("environmentName is marked non-null but is null");
            }
            this.environmentName = environmentName;
            return this;
        }

        @NonNull
        public Builder environment(@Nullable ServiceEnvironmentType environment) {
            if (environment != null) {
                this.environment = environment;
                this.environmentName = environment.name();
            }
            return this;
        }

        @NonNull
        public Builder allowedNodes(@NonNull Collection<String> allowedNodes) {
            if (allowedNodes == null) {
                throw new NullPointerException("allowedNodes is marked non-null but is null");
            }
            this.allowedNodes = new HashSet<String>(allowedNodes);
            return this;
        }

        @NonNull
        public Builder modifyAllowedNodes(@NonNull Consumer<Collection<String>> modifier) {
            if (modifier == null) {
                throw new NullPointerException("modifier is marked non-null but is null");
            }
            modifier.accept(this.allowedNodes);
            return this;
        }

        @NonNull
        public ServiceId build() {
            Preconditions.checkNotNull((Object)this.taskName, (Object)"no task name given");
            Preconditions.checkNotNull((Object)this.environmentName, (Object)"no environment given");
            Preconditions.checkArgument((this.taskServiceId == -1 || this.taskServiceId > 0 ? 1 : 0) != 0, (Object)"taskServiceId <= 0");
            return new ServiceId(this.taskName, this.nameSplitter, Set.copyOf(this.allowedNodes), this.uniqueId, this.taskServiceId, this.nodeUniqueId, this.environmentName, this.environment);
        }
    }
}

