/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import eu.cloudnetservice.common.Nameable;
import eu.cloudnetservice.common.document.gson.JsonDocument;
import eu.cloudnetservice.common.document.property.DefaultedDocPropertyHolder;
import eu.cloudnetservice.common.document.property.DocProperty;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import lombok.NonNull;

public final class ServiceEnvironmentType
implements DefaultedDocPropertyHolder<JsonDocument, ServiceEnvironmentType>,
Nameable,
Cloneable {
    public static final DocProperty<Boolean> JAVA_PROXY = DocProperty.property((String)"isJavaProxy", Boolean.class).withDefault((Object)false);
    public static final DocProperty<Boolean> PE_PROXY = DocProperty.property((String)"isPeProxy", Boolean.class).withDefault((Object)false);
    public static final DocProperty<Boolean> JAVA_SERVER = DocProperty.property((String)"isJavaServer", Boolean.class).withDefault((Object)false);
    public static final DocProperty<Boolean> PE_SERVER = DocProperty.property((String)"isPeServer", Boolean.class).withDefault((Object)false);
    public static final DocProperty<String> PLUGIN_DIR = DocProperty.property((String)"pluginDir", String.class).withDefault((Object)"plugins");
    public static final ServiceEnvironmentType NUKKIT = ServiceEnvironmentType.builder().name("NUKKIT").defaultProcessArguments(Set.of("disable-ansi")).properties((JsonDocument)JsonDocument.newDocument().writeProperty(PE_SERVER, (Object)true)).build();
    public static final ServiceEnvironmentType MINECRAFT_SERVER = ServiceEnvironmentType.builder().name("MINECRAFT_SERVER").defaultProcessArguments(Set.of("nogui")).properties((JsonDocument)JsonDocument.newDocument().writeProperty(JAVA_SERVER, (Object)true)).build();
    public static final ServiceEnvironmentType MODDED_MINECRAFT_SERVER = ServiceEnvironmentType.builder().name("MODDED_MINECRAFT_SERVER").defaultProcessArguments(Set.of("nogui")).properties((JsonDocument)((JsonDocument)JsonDocument.newDocument().writeProperty(JAVA_SERVER, (Object)true)).writeProperty(PLUGIN_DIR, (Object)"mods")).build();
    public static final ServiceEnvironmentType MINESTOM = ServiceEnvironmentType.builder().name("MINESTOM").properties((JsonDocument)((JsonDocument)JsonDocument.newDocument().writeProperty(JAVA_SERVER, (Object)true)).writeProperty(PLUGIN_DIR, (Object)"extensions")).build();
    public static final ServiceEnvironmentType BUNGEECORD = ServiceEnvironmentType.builder().name("BUNGEECORD").defaultServiceStartPort(25565).properties((JsonDocument)JsonDocument.newDocument().writeProperty(JAVA_PROXY, (Object)true)).build();
    public static final ServiceEnvironmentType VELOCITY = ServiceEnvironmentType.builder().name("VELOCITY").defaultServiceStartPort(25565).properties((JsonDocument)JsonDocument.newDocument().writeProperty(JAVA_PROXY, (Object)true)).build();
    public static final ServiceEnvironmentType WATERDOG_PE = ServiceEnvironmentType.builder().name("WATERDOG_PE").defaultServiceStartPort(19132).properties((JsonDocument)JsonDocument.newDocument().writeProperty(PE_PROXY, (Object)true)).build();
    private final String name;
    private final int defaultServiceStartPort;
    private final Set<String> defaultProcessArguments;
    private final JsonDocument properties;

    private ServiceEnvironmentType(@NonNull String name, int defaultServiceStartPort, @NonNull Set<String> defaultProcessArguments, @NonNull JsonDocument properties) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (defaultProcessArguments == null) {
            throw new NullPointerException("defaultProcessArguments is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.name = name;
        this.defaultServiceStartPort = defaultServiceStartPort;
        this.defaultProcessArguments = defaultProcessArguments;
        this.properties = properties;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public static Builder builder(@NonNull ServiceEnvironmentType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return ServiceEnvironmentType.builder().name(type.name()).properties(type.propertyHolder().clone()).defaultServiceStartPort(type.defaultStartPort()).defaultProcessArguments(type.defaultProcessArguments());
    }

    public static boolean minecraftProxy(@NonNull ServiceEnvironmentType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return (Boolean)type.readProperty(JAVA_PROXY) != false || (Boolean)type.readProperty(PE_PROXY) != false;
    }

    public static boolean minecraftServer(@NonNull ServiceEnvironmentType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return (Boolean)type.readProperty(JAVA_SERVER) != false || (Boolean)type.readProperty(PE_SERVER) != false;
    }

    @NonNull
    public String name() {
        return this.name;
    }

    public int defaultStartPort() {
        return this.defaultServiceStartPort;
    }

    @NonNull
    public Collection<String> defaultProcessArguments() {
        return this.defaultProcessArguments;
    }

    public ServiceEnvironmentType clone() {
        try {
            return (ServiceEnvironmentType)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new IllegalStateException();
        }
    }

    @NonNull
    public JsonDocument propertyHolder() {
        return this.properties;
    }

    public String toString() {
        return "ServiceEnvironmentType(name=" + this.name + ", defaultServiceStartPort=" + this.defaultServiceStartPort + ", defaultProcessArguments=" + this.defaultProcessArguments + ", properties=" + this.properties + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceEnvironmentType)) {
            return false;
        }
        ServiceEnvironmentType other = (ServiceEnvironmentType)o;
        if (this.defaultServiceStartPort != other.defaultServiceStartPort) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Set<String> this$defaultProcessArguments = this.defaultProcessArguments;
        Set<String> other$defaultProcessArguments = other.defaultProcessArguments;
        if (this$defaultProcessArguments == null ? other$defaultProcessArguments != null : !((Object)this$defaultProcessArguments).equals(other$defaultProcessArguments)) {
            return false;
        }
        JsonDocument this$properties = this.properties;
        JsonDocument other$properties = other.properties;
        return !(this$properties == null ? other$properties != null : !this$properties.equals(other$properties));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.defaultServiceStartPort;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Set<String> $defaultProcessArguments = this.defaultProcessArguments;
        result = result * 59 + ($defaultProcessArguments == null ? 43 : ((Object)$defaultProcessArguments).hashCode());
        JsonDocument $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        return result;
    }

    public static class Builder {
        private String name;
        private int defaultServiceStartPort = 44955;
        private JsonDocument properties = JsonDocument.newDocument();
        private Set<String> defaultProcessArguments = new LinkedHashSet<String>();

        @NonNull
        public Builder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @NonNull
        public Builder defaultServiceStartPort(int defaultServiceStartPort) {
            this.defaultServiceStartPort = defaultServiceStartPort;
            return this;
        }

        @NonNull
        public Builder properties(@NonNull JsonDocument properties) {
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            this.properties = properties.clone();
            return this;
        }

        @NonNull
        public Builder defaultProcessArguments(@NonNull Collection<String> defaultProcessArguments) {
            if (defaultProcessArguments == null) {
                throw new NullPointerException("defaultProcessArguments is marked non-null but is null");
            }
            this.defaultProcessArguments = new HashSet<String>(defaultProcessArguments);
            return this;
        }

        @NonNull
        public Builder modifyDefaultProcessArguments(@NonNull Consumer<Collection<String>> modifier) {
            if (modifier == null) {
                throw new NullPointerException("modifier is marked non-null but is null");
            }
            modifier.accept(this.defaultProcessArguments);
            return this;
        }

        @NonNull
        public ServiceEnvironmentType build() {
            Preconditions.checkNotNull((Object)this.name, (Object)"no name given");
            Preconditions.checkArgument((this.defaultServiceStartPort >= 0 && this.defaultServiceStartPort <= 65535 ? 1 : 0) != 0, (Object)"invalid default port");
            return new ServiceEnvironmentType(this.name, this.defaultServiceStartPort, (Set<String>)ImmutableSet.copyOf(this.defaultProcessArguments), this.properties);
        }
    }
}

