/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.service;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.common.document.gson.JsonDocument;
import eu.cloudnetservice.common.document.property.DefaultedDocPropertyHolder;
import eu.cloudnetservice.driver.service.ServiceTemplate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import lombok.NonNull;

public class ServiceDeployment
implements DefaultedDocPropertyHolder<JsonDocument, ServiceDeployment>,
Cloneable {
    public static final Set<Pattern> DEFAULT_EXCLUSIONS = Set.of(Pattern.compile("wrapper\\.jar"), Pattern.compile("\\.wrapper/"));
    protected final ServiceTemplate template;
    protected final Collection<Pattern> excludes;
    protected final Collection<Pattern> includes;
    protected final JsonDocument properties;

    protected ServiceDeployment(@NonNull ServiceTemplate template, @NonNull Collection<Pattern> excludes, @NonNull Collection<Pattern> includes, @NonNull JsonDocument properties) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (excludes == null) {
            throw new NullPointerException("excludes is marked non-null but is null");
        }
        if (includes == null) {
            throw new NullPointerException("includes is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.template = template;
        this.excludes = excludes;
        this.includes = includes;
        this.properties = properties;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public static Builder builder(@NonNull ServiceDeployment deployment) {
        if (deployment == null) {
            throw new NullPointerException("deployment is marked non-null but is null");
        }
        return ServiceDeployment.builder().template(deployment.template()).excludes(deployment.excludes()).includes(deployment.includes()).properties(deployment.propertyHolder());
    }

    @NonNull
    public ServiceTemplate template() {
        return this.template;
    }

    @NonNull
    public Collection<Pattern> excludes() {
        return this.excludes;
    }

    @NonNull
    public Collection<Pattern> includes() {
        return this.includes;
    }

    @NonNull
    public ServiceDeployment clone() {
        try {
            return (ServiceDeployment)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new IllegalStateException();
        }
    }

    @NonNull
    public JsonDocument propertyHolder() {
        return this.properties;
    }

    public String toString() {
        return "ServiceDeployment(template=" + this.template + ", excludes=" + this.excludes + ", includes=" + this.includes + ", properties=" + this.properties + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceDeployment)) {
            return false;
        }
        ServiceDeployment other = (ServiceDeployment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ServiceTemplate this$template = this.template;
        ServiceTemplate other$template = other.template;
        if (this$template == null ? other$template != null : !((Object)this$template).equals(other$template)) {
            return false;
        }
        Collection<Pattern> this$excludes = this.excludes;
        Collection<Pattern> other$excludes = other.excludes;
        if (this$excludes == null ? other$excludes != null : !((Object)this$excludes).equals(other$excludes)) {
            return false;
        }
        Collection<Pattern> this$includes = this.includes;
        Collection<Pattern> other$includes = other.includes;
        if (this$includes == null ? other$includes != null : !((Object)this$includes).equals(other$includes)) {
            return false;
        }
        JsonDocument this$properties = this.properties;
        JsonDocument other$properties = other.properties;
        return !(this$properties == null ? other$properties != null : !this$properties.equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceDeployment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ServiceTemplate $template = this.template;
        result = result * 59 + ($template == null ? 43 : ((Object)$template).hashCode());
        Collection<Pattern> $excludes = this.excludes;
        result = result * 59 + ($excludes == null ? 43 : ((Object)$excludes).hashCode());
        Collection<Pattern> $includes = this.includes;
        result = result * 59 + ($includes == null ? 43 : ((Object)$includes).hashCode());
        JsonDocument $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        return result;
    }

    public static class Builder {
        protected ServiceTemplate template;
        protected Collection<Pattern> excludes = new HashSet<Pattern>();
        protected Collection<Pattern> includes = new HashSet<Pattern>();
        protected JsonDocument properties = JsonDocument.newDocument();

        @NonNull
        public Builder template(@NonNull ServiceTemplate template) {
            if (template == null) {
                throw new NullPointerException("template is marked non-null but is null");
            }
            this.template = template;
            return this;
        }

        @NonNull
        public Builder excludes(@NonNull Collection<Pattern> excludes) {
            if (excludes == null) {
                throw new NullPointerException("excludes is marked non-null but is null");
            }
            this.excludes = new HashSet<Pattern>(excludes);
            return this;
        }

        @NonNull
        public Builder modifyExcludes(@NonNull Consumer<Collection<Pattern>> modifier) {
            if (modifier == null) {
                throw new NullPointerException("modifier is marked non-null but is null");
            }
            modifier.accept(this.excludes);
            return this;
        }

        @NonNull
        public Builder withDefaultExclusions() {
            this.excludes.addAll(DEFAULT_EXCLUSIONS);
            return this;
        }

        @NonNull
        public Builder includes(@NonNull Collection<Pattern> includes) {
            if (includes == null) {
                throw new NullPointerException("includes is marked non-null but is null");
            }
            this.includes = new HashSet<Pattern>(includes);
            return this;
        }

        @NonNull
        public Builder modifyIncludes(@NonNull Consumer<Collection<Pattern>> modifier) {
            if (modifier == null) {
                throw new NullPointerException("modifier is marked non-null but is null");
            }
            modifier.accept(this.includes);
            return this;
        }

        @NonNull
        public Builder properties(@NonNull JsonDocument properties) {
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            this.properties = properties.clone();
            return this;
        }

        @NonNull
        public ServiceDeployment build() {
            Preconditions.checkNotNull((Object)this.template, (Object)"no target template given");
            return new ServiceDeployment(this.template, this.excludes, this.includes, this.properties);
        }
    }
}

