/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.service;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.driver.service.ServiceInfoSnapshot;
import java.util.UUID;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public record ServiceCreateResult(@NonNull State state, @Nullable UUID creationId, @Nullable ServiceInfoSnapshot serviceInfo) {
    @Nullable
    private final UUID creationId;
    @Nullable
    private final ServiceInfoSnapshot serviceInfo;
    public static final ServiceCreateResult FAILED = new ServiceCreateResult(State.FAILED, null, null);

    public ServiceCreateResult(@NonNull State state, @Nullable UUID creationId, @Nullable ServiceInfoSnapshot serviceInfo) {
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        Preconditions.checkArgument((state == State.FAILED || creationId != null ? 1 : 0) != 0);
        Preconditions.checkArgument((state != State.CREATED || serviceInfo != null ? 1 : 0) != 0);
    }

    @NonNull
    public static ServiceCreateResult deferred(@NonNull UUID creationId) {
        if (creationId == null) {
            throw new NullPointerException("creationId is marked non-null but is null");
        }
        return new ServiceCreateResult(State.DEFERRED, creationId, null);
    }

    @NonNull
    public static ServiceCreateResult created(@NonNull ServiceInfoSnapshot serviceInfo) {
        if (serviceInfo == null) {
            throw new NullPointerException("serviceInfo is marked non-null but is null");
        }
        return new ServiceCreateResult(State.CREATED, serviceInfo.serviceId().uniqueId(), serviceInfo);
    }

    @NonNull
    public UUID creationId() {
        Preconditions.checkState((this.creationId != null ? 1 : 0) != 0, (Object)"Cannot retrieve creationId for State.FAILED");
        return this.creationId;
    }

    @NonNull
    public ServiceInfoSnapshot serviceInfo() {
        Preconditions.checkState((this.serviceInfo != null ? 1 : 0) != 0, (Object)"Can only retrieve service info for State.CREATED");
        return this.serviceInfo;
    }

    public static enum State {
        CREATED,
        DEFERRED,
        FAILED;

    }
}

