/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.service;

import com.sun.management.OperatingSystemMXBean;
import eu.cloudnetservice.common.unsafe.CPUUsageResolver;
import eu.cloudnetservice.driver.service.ThreadSnapshot;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import lombok.NonNull;

public record ProcessSnapshot(long pid, double cpuUsage, double systemCpuUsage, long maxHeapMemory, long heapUsageMemory, long noHeapUsageMemory, long unloadedClassCount, long totalLoadedClassCount, int currentLoadedClassCount, @NonNull Collection<ThreadSnapshot> threads) implements Cloneable
{
    public static final MemoryMXBean MEMORY_MX_BEAN = ManagementFactory.getMemoryMXBean();
    public static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    public static final ClassLoadingMXBean CLASS_LOADING_MX_BEAN = ManagementFactory.getClassLoadingMXBean();
    public static final OperatingSystemMXBean OS_BEAN = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
    private static final long OWN_PID = ProcessHandle.current().pid();
    private static final ProcessSnapshot EMPTY = new ProcessSnapshot(-1L, -1.0, -1.0, -1L, -1L, -1L, -1L, -1L, -1, Set.of());

    public ProcessSnapshot(long pid, double cpuUsage, double systemCpuUsage, long maxHeapMemory, long heapUsageMemory, long noHeapUsageMemory, long unloadedClassCount, long totalLoadedClassCount, int currentLoadedClassCount, @NonNull Collection<ThreadSnapshot> threads) {
        if (threads == null) {
            throw new NullPointerException("threads is marked non-null but is null");
        }
    }

    @NonNull
    public static ProcessSnapshot empty() {
        return EMPTY;
    }

    @NonNull
    public static ProcessSnapshot self() {
        return new ProcessSnapshot(ProcessSnapshot.ownPID(), CPUUsageResolver.processCPUUsage(), CPUUsageResolver.systemCPUUsage(), MEMORY_MX_BEAN.getHeapMemoryUsage().getMax(), MEMORY_MX_BEAN.getHeapMemoryUsage().getUsed(), MEMORY_MX_BEAN.getNonHeapMemoryUsage().getUsed(), CLASS_LOADING_MX_BEAN.getUnloadedClassCount(), CLASS_LOADING_MX_BEAN.getTotalLoadedClassCount(), CLASS_LOADING_MX_BEAN.getLoadedClassCount(), Arrays.stream(THREAD_MX_BEAN.dumpAllThreads(false, false, 0)).map(ThreadSnapshot::from).toList());
    }

    public static long ownPID() {
        return OWN_PID;
    }

    @NonNull
    public ProcessSnapshot clone() {
        try {
            return (ProcessSnapshot)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new IllegalStateException();
        }
    }
}

