/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import eu.cloudnetservice.driver.service.ServiceEnvironmentType;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import lombok.NonNull;
import org.jetbrains.annotations.Range;
import org.jetbrains.annotations.Unmodifiable;

public record ProcessConfiguration(@NonNull String environment, int maxHeapMemorySize, @Unmodifiable @NonNull Set<String> jvmOptions, @Unmodifiable @NonNull Set<String> processParameters, @Unmodifiable @NonNull Map<String, String> environmentVariables) implements Cloneable
{
    public ProcessConfiguration(@NonNull String environment, int maxHeapMemorySize, @Unmodifiable @NonNull Set<String> jvmOptions, @Unmodifiable @NonNull Set<String> processParameters, @Unmodifiable @NonNull Map<String, String> environmentVariables) {
        if (environment == null) {
            throw new NullPointerException("environment is marked non-null but is null");
        }
        if (jvmOptions == null) {
            throw new NullPointerException("jvmOptions is marked non-null but is null");
        }
        if (processParameters == null) {
            throw new NullPointerException("processParameters is marked non-null but is null");
        }
        if (environmentVariables == null) {
            throw new NullPointerException("environmentVariables is marked non-null but is null");
        }
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public static Builder builder(@NonNull ProcessConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        return ProcessConfiguration.builder().maxHeapMemorySize(configuration.maxHeapMemorySize()).environment(configuration.environment()).jvmOptions(configuration.jvmOptions()).processParameters(configuration.processParameters()).environmentVariables(configuration.environmentVariables());
    }

    public ProcessConfiguration clone() {
        try {
            return (ProcessConfiguration)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new IllegalStateException();
        }
    }

    public static class Builder {
        protected String environment;
        protected int maxHeapMemorySize = 512;
        protected Set<String> jvmOptions = new LinkedHashSet<String>();
        protected Set<String> processParameters = new LinkedHashSet<String>();
        protected Map<String, String> environmentVariables = new HashMap<String, String>();

        @NonNull
        public Builder maxHeapMemorySize(@Range(from=50L, to=0x7FFFFFFFL) int maxHeapMemorySize) {
            Preconditions.checkArgument((maxHeapMemorySize > 50 ? 1 : 0) != 0, (Object)"Max heap memory must be at least 50 mb");
            this.maxHeapMemorySize = maxHeapMemorySize;
            return this;
        }

        @NonNull
        public Builder environment(@NonNull String environment) {
            if (environment == null) {
                throw new NullPointerException("environment is marked non-null but is null");
            }
            this.environment = environment;
            return this;
        }

        @NonNull
        public Builder environment(@NonNull ServiceEnvironmentType environment) {
            if (environment == null) {
                throw new NullPointerException("environment is marked non-null but is null");
            }
            this.environment = environment.name();
            return this;
        }

        @NonNull
        public Builder jvmOptions(@NonNull Collection<String> jvmOptions) {
            if (jvmOptions == null) {
                throw new NullPointerException("jvmOptions is marked non-null but is null");
            }
            this.jvmOptions = new LinkedHashSet<String>(jvmOptions);
            return this;
        }

        @NonNull
        public Builder modifyJvmOptions(@NonNull Consumer<Collection<String>> modifier) {
            if (modifier == null) {
                throw new NullPointerException("modifier is marked non-null but is null");
            }
            modifier.accept(this.jvmOptions);
            return this;
        }

        @NonNull
        public Builder processParameters(@NonNull Collection<String> processParameters) {
            if (processParameters == null) {
                throw new NullPointerException("processParameters is marked non-null but is null");
            }
            this.processParameters = new LinkedHashSet<String>(processParameters);
            return this;
        }

        @NonNull
        public Builder modifyProcessParameters(@NonNull Consumer<Collection<String>> modifier) {
            if (modifier == null) {
                throw new NullPointerException("modifier is marked non-null but is null");
            }
            modifier.accept(this.processParameters);
            return this;
        }

        @NonNull
        public Builder environmentVariables(@NonNull Map<String, String> environmentVariables) {
            if (environmentVariables == null) {
                throw new NullPointerException("environmentVariables is marked non-null but is null");
            }
            this.environmentVariables = new HashMap<String, String>(environmentVariables);
            return this;
        }

        @NonNull
        public Builder modifyEnvironmentVariables(@NonNull Consumer<Map<String, String>> modifier) {
            if (modifier == null) {
                throw new NullPointerException("modifier is marked non-null but is null");
            }
            modifier.accept(this.environmentVariables);
            return this;
        }

        @NonNull
        public ProcessConfiguration build() {
            Preconditions.checkNotNull((Object)this.environment, (Object)"no environment given");
            return new ProcessConfiguration(this.environment, this.maxHeapMemorySize, (Set<String>)ImmutableSet.copyOf(this.jvmOptions), (Set<String>)ImmutableSet.copyOf(this.processParameters), Map.copyOf(this.environmentVariables));
        }
    }
}

