/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.provider;

import eu.cloudnetservice.common.concurrent.Task;
import eu.cloudnetservice.common.document.gson.JsonDocument;
import eu.cloudnetservice.driver.channel.ChannelMessageSender;
import eu.cloudnetservice.driver.network.rpc.annotation.RPCValidation;
import eu.cloudnetservice.driver.service.ServiceDeployment;
import eu.cloudnetservice.driver.service.ServiceInfoSnapshot;
import eu.cloudnetservice.driver.service.ServiceLifeCycle;
import eu.cloudnetservice.driver.service.ServiceRemoteInclusion;
import eu.cloudnetservice.driver.service.ServiceTemplate;
import java.util.Collection;
import java.util.Queue;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

@RPCValidation
public interface SpecificCloudServiceProvider {
    @Nullable
    public ServiceInfoSnapshot serviceInfo();

    public boolean valid();

    @Nullable
    public ServiceInfoSnapshot forceUpdateServiceInfo();

    public void addServiceTemplate(@NonNull ServiceTemplate var1);

    public void addServiceRemoteInclusion(@NonNull ServiceRemoteInclusion var1);

    public void addServiceDeployment(@NonNull ServiceDeployment var1);

    @NonNull
    public Queue<String> cachedLogMessages();

    public boolean toggleScreenEvents(@NonNull ChannelMessageSender var1, @NonNull String var2);

    default public void stop() {
        this.updateLifecycle(ServiceLifeCycle.STOPPED);
    }

    default public void start() {
        this.updateLifecycle(ServiceLifeCycle.RUNNING);
    }

    default public void delete() {
        this.updateLifecycle(ServiceLifeCycle.DELETED);
    }

    public void restart();

    public void updateLifecycle(@NonNull ServiceLifeCycle var1);

    public void deleteFiles();

    public void runCommand(@NonNull String var1);

    @NonNull
    public Collection<ServiceTemplate> installedTemplates();

    @NonNull
    public Collection<ServiceRemoteInclusion> installedInclusions();

    @NonNull
    public Collection<ServiceDeployment> installedDeployments();

    public void includeWaitingServiceTemplates();

    public void includeWaitingServiceTemplates(boolean var1);

    public void includeWaitingServiceInclusions();

    public void deployResources(boolean var1);

    default public void removeAndExecuteDeployments() {
        this.deployResources(true);
    }

    public void updateProperties(@NonNull JsonDocument var1);

    @NonNull
    default public Task<ServiceInfoSnapshot> serviceInfoAsync() {
        return Task.supply(this::serviceInfo);
    }

    @NonNull
    default public Task<Boolean> validAsync() {
        return Task.supply(this::valid);
    }

    @NonNull
    default public Task<ServiceInfoSnapshot> forceUpdateServiceInfoAsync() {
        return Task.supply(this::forceUpdateServiceInfo);
    }

    @NonNull
    default public Task<Void> addServiceTemplateAsync(@NonNull ServiceTemplate serviceTemplate) {
        if (serviceTemplate == null) {
            throw new NullPointerException("serviceTemplate is marked non-null but is null");
        }
        return Task.supply(() -> this.addServiceTemplate(serviceTemplate));
    }

    @NonNull
    default public Task<Void> addServiceRemoteInclusionAsync(@NonNull ServiceRemoteInclusion serviceRemoteInclusion) {
        if (serviceRemoteInclusion == null) {
            throw new NullPointerException("serviceRemoteInclusion is marked non-null but is null");
        }
        return Task.supply(() -> this.addServiceRemoteInclusion(serviceRemoteInclusion));
    }

    @NonNull
    default public Task<Void> addServiceDeploymentAsync(@NonNull ServiceDeployment serviceDeployment) {
        if (serviceDeployment == null) {
            throw new NullPointerException("serviceDeployment is marked non-null but is null");
        }
        return Task.supply(() -> this.addServiceDeployment(serviceDeployment));
    }

    @NonNull
    default public Task<Queue<String>> cachedLogMessagesAsync() {
        return Task.supply(this::cachedLogMessages);
    }

    @NonNull
    default public Task<Boolean> toggleScreenEventsAsync(@NonNull ChannelMessageSender sender, @NonNull String chan) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (chan == null) {
            throw new NullPointerException("chan is marked non-null but is null");
        }
        return Task.supply(() -> this.toggleScreenEvents(sender, chan));
    }

    @NonNull
    default public Task<Void> stopAsync() {
        return this.updateLifecycleAsync(ServiceLifeCycle.STOPPED);
    }

    @NonNull
    default public Task<Void> startAsync() {
        return this.updateLifecycleAsync(ServiceLifeCycle.RUNNING);
    }

    @NonNull
    default public Task<Void> deleteAsync() {
        return this.updateLifecycleAsync(ServiceLifeCycle.DELETED);
    }

    @NonNull
    default public Task<Void> restartAsync() {
        return Task.supply(this::restart);
    }

    @NonNull
    default public Task<Void> updateLifecycleAsync(@NonNull ServiceLifeCycle lifeCycle) {
        if (lifeCycle == null) {
            throw new NullPointerException("lifeCycle is marked non-null but is null");
        }
        return Task.supply(() -> this.updateLifecycle(lifeCycle));
    }

    @NonNull
    default public Task<Void> deleteFilesAsync() {
        return Task.supply(this::deleteFiles);
    }

    @NonNull
    default public Task<Void> runCommandAsync(@NonNull String command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        return Task.supply(() -> this.runCommand(command));
    }

    @NonNull
    default public Task<Void> includeWaitingServiceTemplatesAsync() {
        return Task.supply(() -> this.includeWaitingServiceTemplates());
    }

    @NonNull
    default public Task<Void> includeWaitingServiceTemplatesAsync(boolean force) {
        return Task.supply(() -> this.includeWaitingServiceTemplates(force));
    }

    @NonNull
    default public Task<Void> includeWaitingServiceInclusionsAsync() {
        return Task.supply(this::includeWaitingServiceInclusions);
    }

    @NonNull
    default public Task<Void> deployResourcesAsync(boolean removeDeployments) {
        return Task.supply(() -> this.deployResources(removeDeployments));
    }

    @NonNull
    default public Task<Void> executeAndRemoveDeploymentsAsync() {
        return this.deployResourcesAsync(true);
    }

    @NonNull
    default public Task<Void> updatePropertiesAsync(@NonNull JsonDocument properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return Task.supply(() -> this.updateProperties(properties));
    }
}

