/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.provider;

import eu.cloudnetservice.common.concurrent.Task;
import eu.cloudnetservice.driver.network.rpc.annotation.RPCValidation;
import eu.cloudnetservice.driver.service.ServiceTask;
import java.util.Collection;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

@RPCValidation
public interface ServiceTaskProvider {
    public void reload();

    public @UnmodifiableView @NonNull Collection<ServiceTask> serviceTasks();

    @Nullable
    public ServiceTask serviceTask(@NonNull String var1);

    public boolean addServiceTask(@NonNull ServiceTask var1);

    public void removeServiceTaskByName(@NonNull String var1);

    public void removeServiceTask(@NonNull ServiceTask var1);

    @NonNull
    default public Task<Void> reloadAsync() {
        return Task.supply(this::reload);
    }

    @NonNull
    default public Task<Collection<ServiceTask>> serviceTasksAsync() {
        return Task.supply(this::serviceTasks);
    }

    @NonNull
    default public Task<ServiceTask> serviceTaskAsync(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Task.supply(() -> this.serviceTask(name));
    }

    @NonNull
    default public Task<Boolean> addServiceTaskAsync(@NonNull ServiceTask serviceTask) {
        if (serviceTask == null) {
            throw new NullPointerException("serviceTask is marked non-null but is null");
        }
        return Task.supply(() -> this.addServiceTask(serviceTask));
    }

    @NonNull
    default public Task<Void> removeServiceTaskByNameAsync(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Task.supply(() -> this.removeServiceTaskByName(name));
    }

    @NonNull
    default public Task<Void> removeServiceTaskAsync(@NonNull ServiceTask serviceTask) {
        if (serviceTask == null) {
            throw new NullPointerException("serviceTask is marked non-null but is null");
        }
        return Task.supply(() -> this.removeServiceTask(serviceTask));
    }
}

