/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.provider;

import eu.cloudnetservice.common.concurrent.Task;
import eu.cloudnetservice.driver.network.rpc.annotation.RPCValidation;
import eu.cloudnetservice.driver.service.GroupConfiguration;
import java.util.Collection;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

@RPCValidation
public interface GroupConfigurationProvider {
    public void reload();

    @NonNull
    public @UnmodifiableView Collection<GroupConfiguration> groupConfigurations();

    @Nullable
    public GroupConfiguration groupConfiguration(@NonNull String var1);

    public boolean addGroupConfiguration(@NonNull GroupConfiguration var1);

    public void removeGroupConfigurationByName(@NonNull String var1);

    public void removeGroupConfiguration(@NonNull GroupConfiguration var1);

    @NonNull
    default public Task<Void> reloadAsync() {
        return Task.supply(this::reload);
    }

    @NonNull
    default public Task<Collection<GroupConfiguration>> groupConfigurationsAsync() {
        return Task.supply(this::groupConfigurations);
    }

    @NonNull
    default public Task<GroupConfiguration> groupConfigurationAsync(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Task.supply(() -> this.groupConfiguration(name));
    }

    @NonNull
    default public Task<Boolean> addGroupConfigurationAsync(@NonNull GroupConfiguration groupConfiguration) {
        if (groupConfiguration == null) {
            throw new NullPointerException("groupConfiguration is marked non-null but is null");
        }
        return Task.supply(() -> this.addGroupConfiguration(groupConfiguration));
    }

    @NonNull
    default public Task<Void> removeGroupConfigurationByNameAsync(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Task.supply(() -> this.removeGroupConfigurationByName(name));
    }

    @NonNull
    default public Task<Void> removeGroupConfigurationAsync(@NonNull GroupConfiguration groupConfiguration) {
        if (groupConfiguration == null) {
            throw new NullPointerException("groupConfiguration is marked non-null but is null");
        }
        return Task.supply(() -> this.removeGroupConfiguration(groupConfiguration));
    }
}

