/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.provider;

import eu.cloudnetservice.common.concurrent.Task;
import eu.cloudnetservice.driver.command.CommandInfo;
import eu.cloudnetservice.driver.network.cluster.NetworkClusterNode;
import eu.cloudnetservice.driver.network.cluster.NodeInfoSnapshot;
import eu.cloudnetservice.driver.network.rpc.annotation.RPCValidation;
import java.util.Collection;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

@RPCValidation
public interface ClusterNodeProvider {
    public @UnmodifiableView @NonNull Collection<CommandInfo> consoleCommands();

    @Nullable
    public CommandInfo consoleCommand(@NonNull String var1);

    @NonNull
    public Collection<String> consoleTabCompleteResults(@NonNull String var1);

    @NonNull
    public Collection<String> sendCommandLine(@NonNull String var1);

    public @UnmodifiableView @NonNull Collection<NetworkClusterNode> nodes();

    @Nullable
    public NetworkClusterNode node(@NonNull String var1);

    public boolean addNode(@NonNull NetworkClusterNode var1);

    public boolean removeNode(@NonNull String var1);

    @NonNull
    public Collection<NodeInfoSnapshot> nodeInfoSnapshots();

    @Nullable
    public NodeInfoSnapshot nodeInfoSnapshot(@NonNull String var1);

    @NonNull
    default public Task<Collection<CommandInfo>> consoleCommandsAsync() {
        return Task.supply(this::consoleCommands);
    }

    @NonNull
    default public Task<CommandInfo> consoleCommandAsync(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Task.supply(() -> this.consoleCommand(name));
    }

    @NonNull
    default public Task<Collection<String>> consoleTabCompleteResultsAsync(@NonNull String commandLine) {
        if (commandLine == null) {
            throw new NullPointerException("commandLine is marked non-null but is null");
        }
        return Task.supply(() -> this.consoleTabCompleteResults(commandLine));
    }

    @NonNull
    default public Task<Collection<String>> sendCommandLineAsync(@NonNull String commandLine) {
        if (commandLine == null) {
            throw new NullPointerException("commandLine is marked non-null but is null");
        }
        return Task.supply(() -> this.sendCommandLine(commandLine));
    }

    @NonNull
    default public Task<Collection<NetworkClusterNode>> nodesAsync() {
        return Task.supply(this::nodes);
    }

    @NonNull
    default public Task<NetworkClusterNode> nodeAsync(@NonNull String uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        return Task.supply(() -> this.node(uniqueId));
    }

    @NonNull
    default public Task<Boolean> addNodeAsync(@NonNull NetworkClusterNode node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        return Task.supply(() -> this.addNode(node));
    }

    @NonNull
    default public Task<Boolean> removeNodeAsync(@NonNull String uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        return Task.supply(() -> this.removeNode(uniqueId));
    }

    @NonNull
    default public Task<Collection<NodeInfoSnapshot>> nodeInfoSnapshotsAsync() {
        return Task.supply(this::nodeInfoSnapshots);
    }

    @NonNull
    default public Task<NodeInfoSnapshot> nodeInfoSnapshotAsync(@NonNull String uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        return Task.supply(() -> this.nodeInfoSnapshot(uniqueId));
    }
}

