/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.permission;

import eu.cloudnetservice.common.concurrent.Task;
import eu.cloudnetservice.driver.network.rpc.annotation.RPCValidation;
import eu.cloudnetservice.driver.permission.Permissible;
import eu.cloudnetservice.driver.permission.Permission;
import eu.cloudnetservice.driver.permission.PermissionCheckResult;
import eu.cloudnetservice.driver.permission.PermissionGroup;
import eu.cloudnetservice.driver.permission.PermissionUser;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

@RPCValidation
public interface PermissionManagement {
    @Nullable
    public PermissionManagement childPermissionManagement();

    public void init();

    public void close();

    public boolean reload();

    public boolean testPermissionUser(@Nullable PermissionUser var1);

    public boolean testPermissible(@Nullable Permissible var1);

    @NonNull
    public PermissionUser addPermissionUser(@NonNull String var1, @NonNull String var2, int var3);

    @NonNull
    public PermissionUser addPermissionUser(@NonNull PermissionUser var1);

    @NonNull
    public Collection<PermissionGroup> groupsOf(@Nullable Permissible var1);

    default public boolean hasPermission(@NonNull Permissible permissible, @NonNull Permission permission) {
        if (permissible == null) {
            throw new NullPointerException("permissible is marked non-null but is null");
        }
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        return this.permissionResult(permissible, permission).asBoolean();
    }

    default public boolean hasGroupPermission(@NonNull Permissible permissible, @NonNull String group, @NonNull Permission permission) {
        if (permissible == null) {
            throw new NullPointerException("permissible is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        return this.groupPermissionResult(permissible, group, permission).asBoolean();
    }

    @NonNull
    public PermissionCheckResult permissionResult(@NonNull Permissible var1, @NonNull Permission var2);

    @NonNull
    public PermissionCheckResult groupPermissionResult(@NonNull Permissible var1, @NonNull String var2, @NonNull Permission var3);

    @NonNull
    public PermissionCheckResult groupsPermissionResult(@NonNull Permissible var1, @NonNull String[] var2, @NonNull Permission var3);

    @Nullable
    public Permission findHighestPermission(@NonNull Collection<Permission> var1, @NonNull Permission var2);

    @NonNull
    public Collection<Permission> allPermissions(@NonNull Permissible var1);

    @NonNull
    public Collection<Permission> allGroupPermissions(@NonNull Permissible var1, @Nullable String var2);

    public void updateUser(@NonNull PermissionUser var1);

    public boolean deleteUser(@NonNull String var1);

    public boolean deletePermissionUser(@NonNull PermissionUser var1);

    public boolean containsUser(@NonNull UUID var1);

    public boolean containsOneUser(@NonNull String var1);

    @Nullable
    public PermissionUser user(@NonNull UUID var1);

    @NonNull
    public PermissionUser getOrCreateUser(@NonNull UUID var1, @NonNull String var2);

    @Nullable
    public PermissionUser firstUser(@NonNull String var1);

    @NonNull
    public List<PermissionUser> usersByName(@NonNull String var1);

    @NonNull
    public Collection<PermissionUser> users();

    @NonNull
    public Collection<PermissionUser> usersByGroup(@NonNull String var1);

    @Nullable
    public PermissionGroup defaultPermissionGroup();

    @Nullable
    public PermissionGroup highestPermissionGroup(@NonNull PermissionUser var1);

    @NonNull
    public PermissionGroup addPermissionGroup(@NonNull String var1, int var2);

    @NonNull
    public PermissionGroup addPermissionGroup(@NonNull PermissionGroup var1);

    public void updateGroup(@NonNull PermissionGroup var1);

    public boolean deleteGroup(@NonNull String var1);

    public boolean deletePermissionGroup(@NonNull PermissionGroup var1);

    public boolean containsGroup(@NonNull String var1);

    @Nullable
    public PermissionGroup group(@NonNull String var1);

    @NonNull
    public Collection<PermissionGroup> groups();

    public void groups(@Nullable Collection<PermissionGroup> var1);

    @Nullable
    public PermissionGroup modifyGroup(@NonNull String var1, @NonNull BiConsumer<PermissionGroup, PermissionGroup.Builder> var2);

    @Nullable
    public PermissionUser modifyUser(@NonNull UUID var1, @NonNull BiConsumer<PermissionUser, PermissionUser.Builder> var2);

    @NonNull
    public List<PermissionUser> modifyUsers(@NonNull String var1, @NonNull BiConsumer<PermissionUser, PermissionUser.Builder> var2);

    @NonNull
    public Collection<String> sendCommandLine(@NonNull PermissionUser var1, @NonNull String var2);

    @NonNull
    default public Task<Collection<PermissionGroup>> groupsOfAsync(@Nullable Permissible permissible) {
        return Task.supply(() -> this.groupsOf(permissible));
    }

    @NonNull
    default public Task<PermissionUser> addPermissionUserAsync(@NonNull PermissionUser permissionUser) {
        if (permissionUser == null) {
            throw new NullPointerException("permissionUser is marked non-null but is null");
        }
        return Task.supply(() -> this.addPermissionUser(permissionUser));
    }

    @NonNull
    default public Task<PermissionUser> addUserAsync(@NonNull String name, @NonNull String password, int potency) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        return Task.supply(() -> this.addPermissionUser(name, password, potency));
    }

    @NonNull
    default public Task<Void> updateUserAsync(@NonNull PermissionUser permissionUser) {
        if (permissionUser == null) {
            throw new NullPointerException("permissionUser is marked non-null but is null");
        }
        return Task.supply(() -> this.updateUser(permissionUser));
    }

    @NonNull
    default public Task<Boolean> deleteUserAsync(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Task.supply(() -> this.deleteUser(name));
    }

    @NonNull
    default public Task<Boolean> deletePermissionUserAsync(@NonNull PermissionUser permissionUser) {
        if (permissionUser == null) {
            throw new NullPointerException("permissionUser is marked non-null but is null");
        }
        return Task.supply(() -> this.deletePermissionUser(permissionUser));
    }

    @NonNull
    default public Task<Boolean> containsUserAsync(@NonNull UUID uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        return Task.supply(() -> this.containsUser(uniqueId));
    }

    @NonNull
    default public Task<Boolean> containsOneUserAsync(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Task.supply(() -> this.containsOneUser(name));
    }

    @NonNull
    default public Task<PermissionUser> userAsync(@NonNull UUID uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        return Task.supply(() -> this.user(uniqueId));
    }

    @NonNull
    default public Task<PermissionUser> getOrCreateUserAsync(@NonNull UUID uniqueId, @NonNull String name) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Task.supply(() -> this.getOrCreateUser(uniqueId, name));
    }

    @NonNull
    default public Task<List<PermissionUser>> usersByNameAsync(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Task.supply(() -> this.usersByName(name));
    }

    @NonNull
    default public Task<PermissionUser> firstUserAsync(String name) {
        return Task.supply(() -> this.firstUser(name));
    }

    @NonNull
    default public Task<Collection<PermissionUser>> usersAsync() {
        return Task.supply(this::users);
    }

    @NonNull
    default public Task<Collection<PermissionUser>> usersByGroupAsync(@NonNull String group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        return Task.supply(() -> this.usersByGroup(group));
    }

    @NonNull
    default public Task<PermissionGroup> addPermissionGroupAsync(@NonNull PermissionGroup permissionGroup) {
        if (permissionGroup == null) {
            throw new NullPointerException("permissionGroup is marked non-null but is null");
        }
        return Task.supply(() -> this.addPermissionGroup(permissionGroup));
    }

    @NonNull
    default public Task<PermissionGroup> addGroupAsync(@NonNull String name, int potency) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Task.supply(() -> this.addPermissionGroup(name, potency));
    }

    @NonNull
    default public Task<Void> updateGroupAsync(@NonNull PermissionGroup permissionGroup) {
        if (permissionGroup == null) {
            throw new NullPointerException("permissionGroup is marked non-null but is null");
        }
        return Task.supply(() -> this.updateGroup(permissionGroup));
    }

    @NonNull
    default public Task<Boolean> deleteGroupAsync(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Task.supply(() -> this.deleteGroup(name));
    }

    @NonNull
    default public Task<Boolean> deletePermissionGroupAsync(@NonNull PermissionGroup permissionGroup) {
        if (permissionGroup == null) {
            throw new NullPointerException("permissionGroup is marked non-null but is null");
        }
        return Task.supply(() -> this.deletePermissionGroup(permissionGroup));
    }

    @NonNull
    default public Task<Boolean> containsGroupAsync(@NonNull String group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        return Task.supply(() -> this.containsGroup(group));
    }

    @NonNull
    default public Task<PermissionGroup> groupAsync(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Task.supply(() -> this.group(name));
    }

    @NonNull
    default public Task<PermissionGroup> defaultPermissionGroupAsync() {
        return Task.supply(this::defaultPermissionGroup);
    }

    @NonNull
    default public Task<Collection<PermissionGroup>> groupsAsync() {
        return Task.supply(this::groups);
    }

    @NonNull
    default public Task<Void> groupsAsync(@Nullable Collection<PermissionGroup> groups) {
        return Task.supply(() -> this.groups(groups));
    }

    @NonNull
    default public Task<PermissionGroup> modifyGroupAsync(@NonNull String name, @NonNull BiConsumer<PermissionGroup, PermissionGroup.Builder> modifier) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (modifier == null) {
            throw new NullPointerException("modifier is marked non-null but is null");
        }
        return Task.supply(() -> this.modifyGroup(name, modifier));
    }

    @NonNull
    default public Task<PermissionUser> modifyUserAsync(@NonNull UUID uniqueId, @NonNull BiConsumer<PermissionUser, PermissionUser.Builder> modifier) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        if (modifier == null) {
            throw new NullPointerException("modifier is marked non-null but is null");
        }
        return Task.supply(() -> this.modifyUser(uniqueId, modifier));
    }

    @NonNull
    default public Task<List<PermissionUser>> modifyUsersAsync(@NonNull String name, @NonNull BiConsumer<PermissionUser, PermissionUser.Builder> modifier) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (modifier == null) {
            throw new NullPointerException("modifier is marked non-null but is null");
        }
        return Task.supply(() -> this.modifyUsers(name, modifier));
    }

    @NonNull
    default public Task<Collection<String>> sendCommandLineAsync(@NonNull PermissionUser user, @NonNull String commandLine) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (commandLine == null) {
            throw new NullPointerException("commandLine is marked non-null but is null");
        }
        return Task.supply(() -> this.sendCommandLine(user, commandLine));
    }
}

