/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.permission;

import eu.cloudnetservice.driver.permission.Permission;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public enum PermissionCheckResult {
    ALLOWED(true),
    DENIED(false),
    FORBIDDEN(false);

    private final boolean value;

    private PermissionCheckResult(boolean value) {
        this.value = value;
    }

    @NonNull
    public static PermissionCheckResult fromBoolean(@Nullable Boolean value) {
        return value == null ? DENIED : (value != false ? ALLOWED : FORBIDDEN);
    }

    @NonNull
    public static PermissionCheckResult fromPermission(@Nullable Permission permission) {
        return PermissionCheckResult.fromBoolean(permission == null ? null : Boolean.valueOf(permission.potency() >= 0));
    }

    public boolean asBoolean() {
        return this.value;
    }
}

