/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.permission;

import eu.cloudnetservice.driver.permission.Permissible;
import eu.cloudnetservice.driver.permission.Permission;
import eu.cloudnetservice.driver.permission.PermissionCheckResult;
import eu.cloudnetservice.driver.permission.PermissionGroup;
import eu.cloudnetservice.driver.permission.PermissionManagement;
import eu.cloudnetservice.driver.permission.PermissionUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultPermissionManagement
implements PermissionManagement {
    @Override
    public PermissionManagement childPermissionManagement() {
        return null;
    }

    @Override
    public PermissionGroup highestPermissionGroup(@NonNull PermissionUser permissionUser) {
        if (permissionUser == null) {
            throw new NullPointerException("permissionUser is marked non-null but is null");
        }
        PermissionGroup permissionGroup = null;
        for (PermissionGroup group : this.groupsOf(permissionUser)) {
            if (permissionGroup == null) {
                permissionGroup = group;
                continue;
            }
            if (permissionGroup.potency() > group.potency()) continue;
            permissionGroup = group;
        }
        return permissionGroup != null ? permissionGroup : this.defaultPermissionGroup();
    }

    @Override
    public boolean testPermissionUser(@Nullable PermissionUser permissionUser) {
        if (permissionUser == null) {
            return false;
        }
        return this.testPermissible(permissionUser) || permissionUser.groups().removeIf(groupInfo -> groupInfo.timeOutMillis() > 0L && groupInfo.timeOutMillis() < System.currentTimeMillis());
    }

    @Override
    public boolean testPermissible(@Nullable Permissible permissible) {
        if (permissible == null) {
            return false;
        }
        Predicate<Permission> tester = permission -> permission.timeOutMillis() > 0L && permission.timeOutMillis() < System.currentTimeMillis();
        boolean result = permissible.permissions().removeIf(tester);
        for (Map.Entry<String, Set<Permission>> entry : permissible.groupPermissions().entrySet()) {
            result |= entry.getValue().removeIf(tester);
        }
        return result;
    }

    @Override
    @NonNull
    public Collection<PermissionGroup> groupsOf(@Nullable Permissible permissible) {
        ArrayList<PermissionGroup> permissionGroups = new ArrayList<PermissionGroup>();
        if (permissible == null) {
            return permissionGroups;
        }
        for (String group : permissible.groupNames()) {
            PermissionGroup permissionGroup = this.group(group);
            if (permissionGroup == null) continue;
            permissionGroups.add(permissionGroup);
        }
        if (permissionGroups.isEmpty() && permissible instanceof PermissionUser) {
            permissionGroups.add(this.defaultPermissionGroup());
        }
        return permissionGroups;
    }

    @Override
    @NonNull
    public PermissionCheckResult permissionResult(@NonNull Permissible permissible, @NonNull Permission permission) {
        if (permissible == null) {
            throw new NullPointerException("permissible is marked non-null but is null");
        }
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        return PermissionCheckResult.fromPermission(this.findHighestPermission(this.collectAllPermissions(permissible, null), permission));
    }

    @Override
    @NonNull
    public PermissionCheckResult groupPermissionResult(@NonNull Permissible permissible, @NonNull String group, @NonNull Permission permission) {
        if (permissible == null) {
            throw new NullPointerException("permissible is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        return this.groupsPermissionResult(permissible, new String[]{group}, permission);
    }

    @Override
    @NonNull
    public PermissionCheckResult groupsPermissionResult(@NonNull Permissible permissible, @NonNull String[] groups, @NonNull Permission permission) {
        if (permissible == null) {
            throw new NullPointerException("permissible is marked non-null but is null");
        }
        if (groups == null) {
            throw new NullPointerException("groups is marked non-null but is null");
        }
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        return PermissionCheckResult.fromPermission(this.findHighestPermission(this.collectAllPermissions(permissible, groups), permission));
    }

    @Override
    @Nullable
    public Permission findHighestPermission(@NonNull Collection<Permission> permissions, @NonNull Permission permission) {
        if (permissions == null) {
            throw new NullPointerException("permissions is marked non-null but is null");
        }
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        Permission lastMatch = null;
        for (Permission permissionEntry : permissions) {
            Permission used;
            Permission permission2 = used = lastMatch == null ? permission : lastMatch;
            if (permissionEntry.name().equals("*") && permissionEntry.compareTo(used) >= 0) {
                lastMatch = permissionEntry;
                continue;
            }
            if (permissionEntry.name().endsWith("*") && permission.name().contains(permissionEntry.name().replace("*", "")) && permissionEntry.compareTo(used) >= 0) {
                lastMatch = permissionEntry;
                continue;
            }
            if (!permission.name().equalsIgnoreCase(permissionEntry.name()) || permissionEntry.compareTo(used) < 0) continue;
            lastMatch = permissionEntry;
        }
        return lastMatch;
    }

    @NonNull
    protected Collection<Permission> collectAllPermissions(@NonNull Permissible permissible, @Nullable String[] groups) {
        if (permissible == null) {
            throw new NullPointerException("permissible is marked non-null but is null");
        }
        return this.collectAllPermissionsTo(new HashSet<Permission>(), permissible, groups);
    }

    @NonNull
    protected Collection<Permission> collectAllPermissionsTo(@NonNull Collection<Permission> target, @NonNull Permissible permissible, @Nullable String[] groups) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (permissible == null) {
            throw new NullPointerException("permissible is marked non-null but is null");
        }
        this.collectPermissionsInto(target, permissible, groups);
        this.collectAllGroupPermissionsInto(target, this.groupsOf(permissible), groups, new HashSet<String>());
        return target;
    }

    protected void collectAllGroupPermissionsInto(@NonNull Collection<Permission> target, @NonNull Collection<PermissionGroup> groups, @Nullable String[] taskGroups, @NonNull Collection<String> travelledGroups) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (groups == null) {
            throw new NullPointerException("groups is marked non-null but is null");
        }
        if (travelledGroups == null) {
            throw new NullPointerException("travelledGroups is marked non-null but is null");
        }
        for (PermissionGroup permissionGroup : groups) {
            if (permissionGroup == null || !travelledGroups.add(permissionGroup.name())) continue;
            this.collectPermissionsInto(target, permissionGroup, taskGroups);
            this.collectAllGroupPermissionsInto(target, this.groupsOf(permissionGroup), taskGroups, travelledGroups);
        }
    }

    protected void collectPermissionsInto(@NonNull Collection<Permission> permissions, @NonNull Permissible permissible, @Nullable String[] groups) {
        if (permissions == null) {
            throw new NullPointerException("permissions is marked non-null but is null");
        }
        if (permissible == null) {
            throw new NullPointerException("permissible is marked non-null but is null");
        }
        permissions.addAll(permissible.permissions());
        if (groups != null) {
            for (String group : groups) {
                permissions.addAll(permissible.groupPermissions().getOrDefault(group, Collections.emptySet()));
            }
        }
    }

    @Override
    @NonNull
    public Collection<Permission> allPermissions(@NonNull Permissible permissible) {
        if (permissible == null) {
            throw new NullPointerException("permissible is marked non-null but is null");
        }
        return this.allGroupPermissions(permissible, null);
    }

    @Override
    @NonNull
    public Collection<Permission> allGroupPermissions(@NonNull Permissible permissible, String group) {
        if (permissible == null) {
            throw new NullPointerException("permissible is marked non-null but is null");
        }
        ArrayList<Permission> permissions = new ArrayList<Permission>(permissible.permissions());
        if (group != null && permissible.groupPermissions().containsKey(group)) {
            permissions.addAll((Collection<Permission>)permissible.groupPermissions().get(group));
        }
        for (PermissionGroup permissionGroup : this.groupsOf(permissible)) {
            permissions.addAll(this.allGroupPermissions(permissionGroup, group));
        }
        return permissions;
    }

    @Override
    @Nullable
    public PermissionGroup modifyGroup(@NonNull String name, @NonNull BiConsumer<PermissionGroup, PermissionGroup.Builder> modifier) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (modifier == null) {
            throw new NullPointerException("modifier is marked non-null but is null");
        }
        PermissionGroup group = this.group(name);
        if (group != null) {
            PermissionGroup.Builder builder = PermissionGroup.builder(group);
            modifier.accept(group, builder);
            this.updateGroup(builder.build());
        }
        return group;
    }

    @Override
    @Nullable
    public PermissionUser modifyUser(@NonNull UUID uniqueId, @NonNull BiConsumer<PermissionUser, PermissionUser.Builder> modifier) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        if (modifier == null) {
            throw new NullPointerException("modifier is marked non-null but is null");
        }
        PermissionUser user = this.user(uniqueId);
        if (user != null) {
            PermissionUser.Builder builder = PermissionUser.builder(user);
            modifier.accept(user, builder);
            this.updateUser(builder.build());
        }
        return user;
    }

    @Override
    @NonNull
    public List<PermissionUser> modifyUsers(@NonNull String name, @NonNull BiConsumer<PermissionUser, PermissionUser.Builder> modifier) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (modifier == null) {
            throw new NullPointerException("modifier is marked non-null but is null");
        }
        List<PermissionUser> users = this.usersByName(name);
        for (PermissionUser user : users) {
            PermissionUser.Builder builder = PermissionUser.builder(user);
            modifier.accept(user, builder);
            this.updateUser(builder.build());
        }
        return users;
    }
}

