/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.permission;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import eu.cloudnetservice.driver.permission.CachedPermissionManagement;
import eu.cloudnetservice.driver.permission.DefaultPermissionManagement;
import eu.cloudnetservice.driver.permission.PermissionGroup;
import eu.cloudnetservice.driver.permission.PermissionUser;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultCachedPermissionManagement
extends DefaultPermissionManagement
implements CachedPermissionManagement {
    protected final Map<UUID, AtomicInteger> permissionUserLocks = new ConcurrentHashMap<UUID, AtomicInteger>();
    protected final Map<String, AtomicInteger> permissionGroupLocks = new ConcurrentHashMap<String, AtomicInteger>();
    protected final Cache<UUID, PermissionUser> permissionUserCache = Caffeine.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener((key, value, cause) -> {
        if (key != null && value != null) {
            this.handleUserRemove((UUID)key, (PermissionUser)value, cause);
        }
    }).build();
    protected final Cache<String, PermissionGroup> permissionGroupCache = Caffeine.newBuilder().removalListener((key, value, cause) -> {
        if (key != null && value != null) {
            this.handleGroupRemove((String)key, (PermissionGroup)value, cause);
        }
    }).build();

    @Override
    @NonNull
    public Map<UUID, PermissionUser> cachedPermissionUsers() {
        return this.permissionUserCache.asMap();
    }

    @Override
    @NonNull
    public Map<String, PermissionGroup> cachedPermissionGroups() {
        return this.permissionGroupCache.asMap();
    }

    @Override
    @Nullable
    public PermissionUser cachedUser(@NonNull UUID uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        return (PermissionUser)this.permissionUserCache.getIfPresent((Object)uniqueId);
    }

    @Override
    @Nullable
    public PermissionGroup cachedGroup(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return (PermissionGroup)this.permissionGroupCache.getIfPresent((Object)name);
    }

    @Override
    public void acquireLock(@NonNull PermissionUser user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        this.permissionUserLocks.computeIfAbsent(user.uniqueId(), uuid -> new AtomicInteger()).incrementAndGet();
    }

    @Override
    public void acquireLock(@NonNull PermissionGroup group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        this.permissionGroupLocks.computeIfAbsent(group.name(), name -> new AtomicInteger()).incrementAndGet();
    }

    @Override
    public boolean locked(@NonNull PermissionUser user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        AtomicInteger lockCount = this.permissionUserLocks.get(user.uniqueId());
        return lockCount != null && lockCount.get() > 0;
    }

    @Override
    public boolean locked(@NonNull PermissionGroup group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        AtomicInteger lockCount = this.permissionGroupLocks.get(group.name());
        return lockCount != null && lockCount.get() > 0;
    }

    @Override
    public void unlock(@NonNull PermissionUser user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        AtomicInteger lockCount = this.permissionUserLocks.get(user.uniqueId());
        if (lockCount != null) {
            lockCount.updateAndGet(count -> Math.max(0, count - 1));
        }
    }

    @Override
    public void unlock(@NonNull PermissionGroup group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        AtomicInteger lockCount = this.permissionGroupLocks.get(group.name());
        if (lockCount != null) {
            lockCount.updateAndGet(count -> Math.max(0, count - 1));
        }
    }

    @Override
    public void unlockFully(@NonNull PermissionUser user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        this.permissionUserLocks.remove(user.uniqueId());
    }

    @Override
    public void unlockFully(@NonNull PermissionGroup group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        this.permissionGroupLocks.remove(group.name());
    }

    protected void handleUserRemove(@NonNull UUID key, @NonNull PermissionUser user, @NonNull RemovalCause cause) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (cause == null) {
            throw new NullPointerException("cause is marked non-null but is null");
        }
        if (cause.wasEvicted() && this.locked(user)) {
            this.permissionUserCache.put((Object)key, (Object)user);
        }
    }

    protected void handleGroupRemove(@NonNull String key, @NonNull PermissionGroup group, @NonNull RemovalCause cause) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (cause == null) {
            throw new NullPointerException("cause is marked non-null but is null");
        }
        if (cause.wasEvicted() && this.locked(group)) {
            this.permissionGroupCache.put((Object)key, (Object)group);
        }
    }
}

