/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.rpc;

import com.google.common.util.concurrent.UncheckedTimeoutException;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.protocol.Packet;
import eu.cloudnetservice.driver.network.rpc.defaults.handler.util.ExceptionalResultUtil;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import java.lang.reflect.Type;
import java.util.function.Function;
import lombok.NonNull;
import org.jetbrains.annotations.UnknownNullability;

record RPCResultMapper<T>(@NonNull Type expectedResultType, @NonNull ObjectMapper objectMapper) implements Function<Packet, T>
{
    public RPCResultMapper(@NonNull Type expectedResultType, @NonNull ObjectMapper objectMapper) {
        if (expectedResultType == null) {
            throw new NullPointerException("expectedResultType is marked non-null but is null");
        }
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
    }

    @Override
    public @UnknownNullability T apply(@UnknownNullability Packet response) {
        if (response.readable()) {
            DataBuf content = response.content();
            if (content.readBoolean()) {
                return this.objectMapper.readObject(content, this.expectedResultType);
            }
            ExceptionalResultUtil.rethrowException(content);
            return null;
        }
        throw new UncheckedTimeoutException("Query future was completed before rpc was able to respond");
    }
}

