/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.rpc;

import eu.cloudnetservice.common.concurrent.Task;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.protocol.Packet;
import eu.cloudnetservice.driver.network.rpc.RPC;
import eu.cloudnetservice.driver.network.rpc.RPCChain;
import eu.cloudnetservice.driver.network.rpc.defaults.DefaultRPCProvider;
import eu.cloudnetservice.driver.network.rpc.defaults.rpc.RPCResultMapper;
import eu.cloudnetservice.driver.network.rpc.exception.RPCException;
import eu.cloudnetservice.driver.network.rpc.exception.RPCExecutionException;
import eu.cloudnetservice.driver.network.rpc.packet.RPCRequestPacket;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import lombok.NonNull;

public class DefaultRPCChain
extends DefaultRPCProvider
implements RPCChain {
    protected final RPC rootRPC;
    protected final RPC headRPC;
    protected final List<RPC> rpcChain;

    protected DefaultRPCChain(@NonNull RPC rootRPC, @NonNull RPC headRPC) {
        this(rootRPC, headRPC, List.of(headRPC));
        if (rootRPC == null) {
            throw new NullPointerException("rootRPC is marked non-null but is null");
        }
        if (headRPC == null) {
            throw new NullPointerException("headRPC is marked non-null but is null");
        }
    }

    protected DefaultRPCChain(@NonNull RPC rootRPC, @NonNull RPC headRPC, @NonNull List<RPC> rpcChain) {
        super(headRPC.targetClass(), headRPC.objectMapper(), headRPC.dataBufFactory());
        if (rootRPC == null) {
            throw new NullPointerException("rootRPC is marked non-null but is null");
        }
        if (headRPC == null) {
            throw new NullPointerException("headRPC is marked non-null but is null");
        }
        if (rpcChain == null) {
            throw new NullPointerException("rpcChain is marked non-null but is null");
        }
        this.rootRPC = rootRPC;
        this.headRPC = headRPC;
        this.rpcChain = new LinkedList<RPC>(rpcChain);
    }

    @Override
    @NonNull
    public RPCChain join(@NonNull RPC rpc) {
        if (rpc == null) {
            throw new NullPointerException("rpc is marked non-null but is null");
        }
        LinkedList<RPC> newChain = new LinkedList<RPC>(this.rpcChain);
        newChain.add(rpc);
        return new DefaultRPCChain(this.rootRPC, rpc, newChain);
    }

    @Override
    @NonNull
    public RPC head() {
        return this.rootRPC;
    }

    @Override
    @NonNull
    public Collection<RPC> joins() {
        return this.rpcChain;
    }

    @Override
    public void fireAndForget() {
        this.fireAndForget(Objects.requireNonNull(this.rootRPC.sender().associatedComponent().firstChannel()));
    }

    @Override
    @NonNull
    public <T> T fireSync() {
        return this.fireSync(Objects.requireNonNull(this.rootRPC.sender().associatedComponent().firstChannel()));
    }

    @Override
    @NonNull
    public <T> Task<T> fire() {
        return this.fire(Objects.requireNonNull(this.rootRPC.sender().associatedComponent().firstChannel()));
    }

    @Override
    public void fireAndForget(@NonNull NetworkChannel component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        this.headRPC.disableResultExpectation();
        this.fireSync(component);
    }

    @Override
    @NonNull
    public <T> T fireSync(@NonNull NetworkChannel component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        try {
            Task<T> queryTask = this.fire(component);
            return (T)queryTask.get();
        }
        catch (ExecutionException exception) {
            Throwable throwable = exception.getCause();
            if (throwable instanceof RPCExecutionException) {
                RPCExecutionException rpcExecutionException = (RPCExecutionException)throwable;
                throw rpcExecutionException;
            }
            throw new RPCException(this, (Exception)exception);
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new IllegalThreadStateException();
        }
    }

    @Override
    @NonNull
    public <T> Task<T> fire(@NonNull NetworkChannel component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        DataBuf.Mutable dataBuf = this.dataBufFactory.createEmpty().writeBoolean(true).writeInt(this.rpcChain.size() + 1);
        this.writeRPCInformation(dataBuf, this.rootRPC, false);
        for (int i = 0; i < this.rpcChain.size(); ++i) {
            this.writeRPCInformation(dataBuf, this.rpcChain.get(i), i < this.rpcChain.size() - 1);
        }
        if (this.headRPC.expectsResult()) {
            return Task.wrapFuture((CompletableFuture)component.sendQueryAsync(new RPCRequestPacket(dataBuf)).thenApply(new RPCResultMapper(this.headRPC.expectedResultType(), this.objectMapper)));
        }
        component.sendPacket((Packet)new RPCRequestPacket(dataBuf));
        return Task.completedTask(null);
    }

    protected void writeRPCInformation(@NonNull DataBuf.Mutable dataBuf, @NonNull RPC rpc, boolean last) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        if (rpc == null) {
            throw new NullPointerException("rpc is marked non-null but is null");
        }
        dataBuf.writeString(rpc.className()).writeString(rpc.methodName()).writeBoolean(!last || rpc.expectsResult()).writeInt(rpc.arguments().length);
        for (Object argument : rpc.arguments()) {
            this.objectMapper.writeObject(dataBuf, argument);
        }
    }
}

