/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.rpc;

import eu.cloudnetservice.common.concurrent.Task;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.buffer.DataBufFactory;
import eu.cloudnetservice.driver.network.protocol.Packet;
import eu.cloudnetservice.driver.network.rpc.RPC;
import eu.cloudnetservice.driver.network.rpc.RPCChain;
import eu.cloudnetservice.driver.network.rpc.RPCSender;
import eu.cloudnetservice.driver.network.rpc.defaults.DefaultRPCProvider;
import eu.cloudnetservice.driver.network.rpc.defaults.rpc.DefaultRPCChain;
import eu.cloudnetservice.driver.network.rpc.defaults.rpc.RPCResultMapper;
import eu.cloudnetservice.driver.network.rpc.exception.RPCException;
import eu.cloudnetservice.driver.network.rpc.exception.RPCExecutionException;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import eu.cloudnetservice.driver.network.rpc.packet.RPCRequestPacket;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class DefaultRPC
extends DefaultRPCProvider
implements RPC {
    private final RPCSender sender;
    private final String className;
    private final String methodName;
    private final Object[] arguments;
    private final Type expectedResultType;
    private boolean resultExpectation = true;

    public DefaultRPC(@NonNull RPCSender sender, @NonNull Class<?> clazz, @NonNull String methodName, @NonNull Object[] arguments, @NonNull ObjectMapper objectMapper, @NonNull Type expectedResultType, @NonNull DataBufFactory dataBufFactory) {
        super(clazz, objectMapper, dataBufFactory);
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (methodName == null) {
            throw new NullPointerException("methodName is marked non-null but is null");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (expectedResultType == null) {
            throw new NullPointerException("expectedResultType is marked non-null but is null");
        }
        if (dataBufFactory == null) {
            throw new NullPointerException("dataBufFactory is marked non-null but is null");
        }
        this.sender = sender;
        this.className = clazz.getCanonicalName();
        this.methodName = methodName;
        this.arguments = arguments;
        this.expectedResultType = expectedResultType;
    }

    @Override
    @NonNull
    public RPCChain join(@NonNull RPC rpc) {
        if (rpc == null) {
            throw new NullPointerException("rpc is marked non-null but is null");
        }
        return new DefaultRPCChain(this, rpc);
    }

    @Override
    @NonNull
    public RPCSender sender() {
        return this.sender;
    }

    @Override
    @NonNull
    public String className() {
        return this.className;
    }

    @Override
    @NonNull
    public String methodName() {
        return this.methodName;
    }

    @Override
    @NonNull
    public Object[] arguments() {
        return this.arguments;
    }

    @Override
    @NonNull
    public Type expectedResultType() {
        return this.expectedResultType;
    }

    @Override
    @NonNull
    public RPC disableResultExpectation() {
        this.resultExpectation = false;
        return this;
    }

    @Override
    public boolean expectsResult() {
        return this.resultExpectation;
    }

    @Override
    public void fireAndForget() {
        this.fireAndForget(Objects.requireNonNull(this.sender.associatedComponent().firstChannel()));
    }

    @Override
    @Nullable
    public <T> T fireSync() {
        return this.fireSync(Objects.requireNonNull(this.sender.associatedComponent().firstChannel()));
    }

    @Override
    @NonNull
    public <T> Task<T> fire() {
        return this.fire(Objects.requireNonNull(this.sender.associatedComponent().firstChannel()));
    }

    @Override
    public void fireAndForget(@NonNull NetworkChannel component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        this.disableResultExpectation().fireSync(component);
    }

    @Override
    @Nullable
    public <T> T fireSync(@NonNull NetworkChannel component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        try {
            Task<T> queryTask = this.fire(component);
            return (T)queryTask.get();
        }
        catch (ExecutionException exception) {
            Throwable throwable = exception.getCause();
            if (throwable instanceof RPCExecutionException) {
                RPCExecutionException executionException = (RPCExecutionException)throwable;
                throw executionException;
            }
            throw new RPCException(this, (Exception)exception);
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new IllegalThreadStateException();
        }
    }

    @Override
    @NonNull
    public <T> Task<T> fire(@NonNull NetworkChannel component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        DataBuf.Mutable dataBuf = this.dataBufFactory.createEmpty().writeBoolean(false).writeString(this.className).writeString(this.methodName).writeBoolean(this.resultExpectation).writeInt(this.arguments.length);
        for (Object argument : this.arguments) {
            this.objectMapper.writeObject(dataBuf, argument);
        }
        if (this.resultExpectation) {
            return Task.wrapFuture((CompletableFuture)component.sendQueryAsync(new RPCRequestPacket(dataBuf)).thenApply(new RPCResultMapper(this.expectedResultType, this.objectMapper)));
        }
        component.sendPacket((Packet)new RPCRequestPacket(dataBuf));
        return Task.completedTask(null);
    }
}

