/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.object.serializers;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import eu.cloudnetservice.driver.network.rpc.object.ObjectSerializer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Supplier;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class MapObjectSerializer
implements ObjectSerializer<Map<?, ?>> {
    private final Supplier<Map<?, ?>> mapFactory;

    protected MapObjectSerializer(@NonNull Supplier<Map<?, ?>> mapFactory) {
        if (mapFactory == null) {
            throw new NullPointerException("mapFactory is marked non-null but is null");
        }
        this.mapFactory = mapFactory;
    }

    @NonNull
    public static MapObjectSerializer of(@NonNull Supplier<Map<?, ?>> mapFactory) {
        if (mapFactory == null) {
            throw new NullPointerException("mapFactory is marked non-null but is null");
        }
        return new MapObjectSerializer(mapFactory);
    }

    @Override
    @Nullable
    public Map<?, ?> read(@NonNull DataBuf source, @NonNull Type type, @NonNull ObjectMapper caller) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        Map<?, ?> map = this.mapFactory.get();
        int mapSize = source.readInt();
        if (mapSize == 0) {
            return map;
        }
        Preconditions.checkState((boolean)(type instanceof ParameterizedType), (Object)"Map rpc read called without parameterized type");
        Type keyType = ((ParameterizedType)type).getActualTypeArguments()[0];
        Type valueType = ((ParameterizedType)type).getActualTypeArguments()[1];
        for (int i = 0; i < mapSize; ++i) {
            map.put(caller.readObject(source, keyType), caller.readObject(source, valueType));
        }
        return map;
    }

    @Override
    public void write(@NonNull DataBuf.Mutable dataBuf, @Nullable Map<?, ?> object, @NonNull Type type, @NonNull ObjectMapper caller) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        dataBuf.writeInt(object == null ? 0 : object.size());
        if (object != null) {
            for (Map.Entry<?, ?> entry : object.entrySet()) {
                caller.writeObject(dataBuf, entry.getKey());
                caller.writeObject(dataBuf, entry.getValue());
            }
        }
    }
}

