/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.object.serializers;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.buffer.DataBufable;
import eu.cloudnetservice.driver.network.rpc.defaults.handler.invoker.MethodInvoker;
import eu.cloudnetservice.driver.network.rpc.defaults.handler.invoker.MethodInvokerGenerator;
import eu.cloudnetservice.driver.network.rpc.exception.MissingNoArgsConstructorException;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import eu.cloudnetservice.driver.network.rpc.object.ObjectSerializer;
import java.lang.reflect.Type;
import java.util.Objects;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class DataBufableObjectSerializer
implements ObjectSerializer<DataBufable> {
    private static final Object[] NO_ARGS = new Object[0];
    private final MethodInvokerGenerator generator = new MethodInvokerGenerator();
    private final Cache<Type, MethodInvoker> cachedConstructors = Caffeine.newBuilder().build();

    @Override
    @Nullable
    public DataBufable read(@NonNull DataBuf source, @NonNull Type type, @NonNull ObjectMapper caller) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        Preconditions.checkState((boolean)(type instanceof Class), (Object)"Call to data buf reader as non-class");
        Class clazz = (Class)type;
        MethodInvoker invoker = (MethodInvoker)this.cachedConstructors.get((Object)type, $ -> {
            try {
                clazz.getDeclaredConstructor(new Class[0]);
                return this.generator.makeNoArgsConstructorInvoker(clazz);
            }
            catch (NoSuchMethodException exception) {
                throw new MissingNoArgsConstructorException(clazz);
            }
        });
        DataBufable object = Objects.requireNonNull((DataBufable)invoker.callMethod(NO_ARGS));
        object.readData(source);
        return object;
    }

    @Override
    public void write(@NonNull DataBuf.Mutable dataBuf, @NonNull DataBufable object, @NonNull Type type, @NonNull ObjectMapper caller) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        object.writeData(dataBuf);
    }
}

