/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.object.data;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Preconditions;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.rpc.defaults.object.data.DataClassInformation;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import eu.cloudnetservice.driver.network.rpc.object.ObjectSerializer;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class DataClassSerializer
implements ObjectSerializer<Object> {
    private final LoadingCache<Type, DataClassInformation> dataClassInformationCache = Caffeine.newBuilder().build(key -> DataClassInformation.createClassInformation((Class)key));

    @Override
    @Nullable
    public Object read(@NonNull DataBuf source, @NonNull Type type, @NonNull ObjectMapper caller) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        Preconditions.checkState((boolean)(type instanceof Class), (Object)"Cannot call data class serializer on non-class");
        Class clazz = (Class)type;
        if (clazz.isArray()) {
            return this.readArray(source, clazz, caller);
        }
        return ((DataClassInformation)this.dataClassInformationCache.get((Object)type)).instanceCreator().makeInstance(source, caller);
    }

    @Override
    public void write(@NonNull DataBuf.Mutable dataBuf, @NonNull Object object, @NonNull Type type, @NonNull ObjectMapper caller) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        Preconditions.checkState((boolean)(type instanceof Class), (Object)"Cannot call data class serializer on non-class");
        Class clazz = (Class)type;
        if (clazz.isArray()) {
            this.writeArray(dataBuf, object, caller);
            return;
        }
        ((DataClassInformation)this.dataClassInformationCache.get((Object)type)).informationWriter().writeInformation(dataBuf, object, caller);
    }

    @Nullable
    protected Object readArray(@NonNull DataBuf source, @NonNull Class<?> clazz, @NonNull ObjectMapper caller) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        Class<?> arrayType = clazz.getComponentType();
        int size = source.readInt();
        Object array = Array.newInstance(arrayType, size);
        for (int i = 0; i < size; ++i) {
            Array.set(array, i, caller.readObject(source, arrayType));
        }
        return array;
    }

    protected void writeArray(@NonNull DataBuf.Mutable dataBuf, @NonNull Object object, @NonNull ObjectMapper caller) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        int arraySize = Array.getLength(object);
        dataBuf.writeInt(arraySize);
        for (int i = 0; i < arraySize; ++i) {
            caller.writeObject(dataBuf, Array.get(object, i));
        }
    }
}

