/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.object;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import dev.derklaro.aerogel.auto.Provides;
import eu.cloudnetservice.common.collection.Pair;
import eu.cloudnetservice.common.document.gson.JsonDocument;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.buffer.DataBufable;
import eu.cloudnetservice.driver.network.rpc.defaults.object.data.DataClassSerializer;
import eu.cloudnetservice.driver.network.rpc.defaults.object.serializers.CollectionObjectSerializer;
import eu.cloudnetservice.driver.network.rpc.defaults.object.serializers.DataBufObjectSerializer;
import eu.cloudnetservice.driver.network.rpc.defaults.object.serializers.DataBufableObjectSerializer;
import eu.cloudnetservice.driver.network.rpc.defaults.object.serializers.EnumObjectSerializer;
import eu.cloudnetservice.driver.network.rpc.defaults.object.serializers.FunctionalObjectSerializer;
import eu.cloudnetservice.driver.network.rpc.defaults.object.serializers.JsonDocumentObjectSerializer;
import eu.cloudnetservice.driver.network.rpc.defaults.object.serializers.MapObjectSerializer;
import eu.cloudnetservice.driver.network.rpc.defaults.object.serializers.OptionalObjectSerializer;
import eu.cloudnetservice.driver.network.rpc.defaults.object.serializers.PathObjectSerializer;
import eu.cloudnetservice.driver.network.rpc.defaults.object.serializers.PatternObjectSerializer;
import eu.cloudnetservice.driver.network.rpc.defaults.object.serializers.UUIDObjectSerializer;
import eu.cloudnetservice.driver.network.rpc.exception.MissingObjectSerializerException;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import eu.cloudnetservice.driver.network.rpc.object.ObjectSerializer;
import jakarta.inject.Singleton;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Provides(value={ObjectMapper.class})
public class DefaultObjectMapper
implements ObjectMapper {
    public static final ObjectMapper DEFAULT_MAPPER;
    private static final Map<Type, ObjectSerializer<?>> DEFAULT_SERIALIZERS;
    private final Map<Type, ObjectSerializer<?>> registeredSerializers = new ConcurrentHashMap();
    private final LoadingCache<Type, Collection<Pair<Type, Type>>> typeCache = Caffeine.newBuilder().expireAfterAccess(Duration.ofDays(1L)).scheduler(Scheduler.systemScheduler()).build(key -> {
        LinkedList<Pair> types = new LinkedList<Pair>();
        for (TypeToken type : TypeToken.of((Type)key).getTypes()) {
            types.add(new Pair((Object)type.getType(), (Object)type.getRawType()));
        }
        return types;
    });

    public DefaultObjectMapper() {
        this(true);
    }

    public DefaultObjectMapper(boolean registerDefaultSerializers) {
        if (registerDefaultSerializers) {
            this.registeredSerializers.putAll(DEFAULT_SERIALIZERS);
        }
    }

    @Override
    @NonNull
    public ObjectMapper unregisterBinding(@NonNull Type type, boolean superTypes) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (superTypes) {
            Collection subTypes = (Collection)this.typeCache.get((Object)type);
            for (Pair subType : subTypes) {
                this.registeredSerializers.remove(subType.first());
                this.registeredSerializers.remove(subType.second());
            }
        } else {
            this.registeredSerializers.remove(type);
        }
        return this;
    }

    @Override
    @NonNull
    public ObjectMapper unregisterBindings(@NonNull ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("classLoader is marked non-null but is null");
        }
        for (Map.Entry<Type, ObjectSerializer<?>> entry : this.registeredSerializers.entrySet()) {
            if (!entry.getValue().getClass().getClassLoader().equals(classLoader)) continue;
            this.registeredSerializers.remove(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    @NonNull
    public <T> ObjectMapper registerBinding(@NonNull Type type, @NonNull ObjectSerializer<T> serializer, boolean superTypes) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (serializer == null) {
            throw new NullPointerException("serializer is marked non-null but is null");
        }
        if (superTypes) {
            Collection subTypes = (Collection)this.typeCache.get((Object)type);
            for (Pair subType : subTypes) {
                this.registeredSerializers.putIfAbsent((Type)subType.first(), serializer);
                this.registeredSerializers.putIfAbsent((Type)subType.second(), serializer);
            }
        } else {
            this.registeredSerializers.putIfAbsent(type, serializer);
        }
        return this;
    }

    @Override
    @NonNull
    public <T> DataBuf.Mutable writeObject(@NonNull DataBuf.Mutable dataBuf, @Nullable T object) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        return dataBuf.writeNullable(object, (buffer, obj) -> {
            Pair subType;
            Collection subTypes = (Collection)this.typeCache.get(obj.getClass());
            ObjectSerializer<Object> serializer = null;
            Iterator iterator = subTypes.iterator();
            while (iterator.hasNext() && ((serializer = this.serializerForType((Pair<Type, Type>)(subType = (Pair)iterator.next()))) == null || !serializer.preWriteCheckAccepts(obj, this))) {
            }
            if (serializer == null || !serializer.preWriteCheckAccepts(obj, this)) {
                throw new MissingObjectSerializerException(obj.getClass());
            }
            serializer.write((DataBuf.Mutable)buffer, obj, obj.getClass(), this);
        });
    }

    @Override
    @Nullable
    public <T> T readObject(@NonNull DataBuf dataBuf, @NonNull Type type) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return (T)dataBuf.readNullable(buffer -> {
            Pair subType;
            Collection subTypes = (Collection)this.typeCache.get((Object)type);
            ObjectSerializer serializer = null;
            Iterator iterator = subTypes.iterator();
            while (iterator.hasNext() && ((serializer = this.serializerForType((Pair<Type, Type>)(subType = (Pair)iterator.next()))) == null || !serializer.preReadCheckAccepts(type, this))) {
            }
            if (serializer == null || !serializer.preReadCheckAccepts(type, this)) {
                throw new MissingObjectSerializerException(type);
            }
            return serializer.read((DataBuf)buffer, type, this);
        });
    }

    @Nullable
    protected <T> ObjectSerializer<T> serializerForType(@NonNull Pair<Type, Type> typePair) {
        if (typePair == null) {
            throw new NullPointerException("typePair is marked non-null but is null");
        }
        ObjectSerializer<?> byType = this.registeredSerializers.get(typePair.first());
        return byType == null ? this.registeredSerializers.get(typePair.second()) : byType;
    }

    static {
        DEFAULT_SERIALIZERS = ImmutableMap.builder().put(Boolean.TYPE, FunctionalObjectSerializer.of(DataBuf::readBoolean, DataBuf.Mutable::writeBoolean)).put(Boolean.class, FunctionalObjectSerializer.of(DataBuf::readBoolean, DataBuf.Mutable::writeBoolean)).put(Byte.TYPE, FunctionalObjectSerializer.of(DataBuf::readByte, DataBuf.Mutable::writeByte)).put(Byte.class, FunctionalObjectSerializer.of(DataBuf::readByte, DataBuf.Mutable::writeByte)).put(Short.TYPE, FunctionalObjectSerializer.of(DataBuf::readShort, DataBuf.Mutable::writeShort)).put(Short.class, FunctionalObjectSerializer.of(DataBuf::readShort, DataBuf.Mutable::writeShort)).put(Integer.TYPE, FunctionalObjectSerializer.of(DataBuf::readInt, DataBuf.Mutable::writeInt)).put(Integer.class, FunctionalObjectSerializer.of(DataBuf::readInt, DataBuf.Mutable::writeInt)).put(Long.TYPE, FunctionalObjectSerializer.of(DataBuf::readLong, DataBuf.Mutable::writeLong)).put(Long.class, FunctionalObjectSerializer.of(DataBuf::readLong, DataBuf.Mutable::writeLong)).put(Float.TYPE, FunctionalObjectSerializer.of(DataBuf::readFloat, DataBuf.Mutable::writeFloat)).put(Float.class, FunctionalObjectSerializer.of(DataBuf::readFloat, DataBuf.Mutable::writeFloat)).put(Double.TYPE, FunctionalObjectSerializer.of(DataBuf::readDouble, DataBuf.Mutable::writeDouble)).put(Double.class, FunctionalObjectSerializer.of(DataBuf::readDouble, DataBuf.Mutable::writeDouble)).put(Character.TYPE, FunctionalObjectSerializer.of(DataBuf::readChar, DataBuf.Mutable::writeChar)).put(Character.class, FunctionalObjectSerializer.of(DataBuf::readChar, DataBuf.Mutable::writeChar)).put(String.class, FunctionalObjectSerializer.of(DataBuf::readString, DataBuf.Mutable::writeString)).put(byte[].class, FunctionalObjectSerializer.of(DataBuf::readByteArray, DataBuf.Mutable::writeByteArray)).put(UUID.class, (Object)new UUIDObjectSerializer()).put(Pattern.class, (Object)new PatternObjectSerializer()).put(Optional.class, (Object)new OptionalObjectSerializer()).put(Collection.class, (Object)CollectionObjectSerializer.of(ArrayList::new)).put(List.class, (Object)CollectionObjectSerializer.of(ArrayList::new)).put(Set.class, (Object)CollectionObjectSerializer.of(HashSet::new)).put(NavigableSet.class, (Object)CollectionObjectSerializer.of(TreeSet::new)).put(Vector.class, (Object)CollectionObjectSerializer.of(Vector::new)).put(Queue.class, (Object)CollectionObjectSerializer.of(LinkedList::new)).put(BlockingQueue.class, (Object)CollectionObjectSerializer.of(LinkedBlockingDeque::new)).put(Map.class, (Object)MapObjectSerializer.of(HashMap::new)).put(ConcurrentMap.class, (Object)MapObjectSerializer.of(ConcurrentHashMap::new)).put(NavigableMap.class, (Object)MapObjectSerializer.of(TreeMap::new)).put(ConcurrentNavigableMap.class, (Object)MapObjectSerializer.of(ConcurrentSkipListMap::new)).put(Path.class, (Object)new PathObjectSerializer()).put(DataBuf.class, (Object)new DataBufObjectSerializer()).put(DataBufable.class, (Object)new DataBufableObjectSerializer()).put(JsonDocument.class, (Object)new JsonDocumentObjectSerializer()).put(Enum.class, (Object)new EnumObjectSerializer()).put(Object.class, (Object)new DataClassSerializer()).build();
        DEFAULT_MAPPER = new DefaultObjectMapper();
    }
}

