/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.handler.invoker;

import eu.cloudnetservice.common.StringUtil;
import eu.cloudnetservice.driver.network.rpc.defaults.MethodInformation;
import eu.cloudnetservice.driver.network.rpc.defaults.handler.invoker.MethodInvoker;
import eu.cloudnetservice.driver.network.rpc.exception.ClassCreationException;
import eu.cloudnetservice.driver.util.asm.AsmHelper;
import eu.cloudnetservice.driver.util.define.ClassDefiners;
import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.Constructor;
import lombok.NonNull;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class MethodInvokerGenerator {
    private static final String SUPER = "java/lang/Object";
    private static final String OBJ_DESCRIPTOR = Type.getDescriptor(Object.class);
    private static final String[] METHOD_INVOKER = new String[]{Type.getInternalName(MethodInvoker.class)};
    private static final String CALL_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Object[].class)});
    private static final String CONSTRUCTOR_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Object.class)});
    private static final String CLASS_NAME_FORMAT = "%s$GeneratedInvoker_%s_%s";
    private static final String NO_ARGS_CONSTRUCTOR_CLASS_NAME_FORMAT = "%s$GeneratedConstructorInvoker_%s";

    @NonNull
    public MethodInvoker makeMethodInvoker(@NonNull MethodInformation methodInfo) {
        if (methodInfo == null) {
            throw new NullPointerException("methodInfo is marked non-null but is null");
        }
        try {
            String className = String.format(CLASS_NAME_FORMAT, Type.getInternalName(methodInfo.definingClass()), methodInfo.name(), StringUtil.generateRandomString((int)25));
            ClassWriter cw = new ClassWriter(3);
            cw.visit(52, 17, className, null, SUPER, METHOD_INVOKER);
            cw.visitField(18, "instance", OBJ_DESCRIPTOR, null, null).visitEnd();
            MethodVisitor mv = cw.visitMethod(1, "<init>", CONSTRUCTOR_DESCRIPTOR, null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, SUPER, "<init>", "()V", false);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitFieldInsn(181, className, "instance", OBJ_DESCRIPTOR);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            mv = cw.visitMethod(1, "callMethod", CALL_METHOD_DESCRIPTOR, null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, "instance", OBJ_DESCRIPTOR);
            mv.visitTypeInsn(192, Type.getInternalName(methodInfo.definingClass()));
            Type[] arguments = new Type[methodInfo.arguments().length];
            for (int i = 0; i < methodInfo.arguments().length; ++i) {
                Class rawType = GenericTypeReflector.erase((java.lang.reflect.Type)methodInfo.arguments()[i]);
                mv.visitVarInsn(25, 1);
                AsmHelper.pushInt(mv, i);
                mv.visitInsn(50);
                if (rawType.isPrimitive()) {
                    AsmHelper.wrapperToPrimitive(mv, rawType);
                } else {
                    mv.visitTypeInsn(192, Type.getInternalName((Class)rawType));
                }
                arguments[i] = Type.getType((Class)rawType);
            }
            mv.visitMethodInsn(methodInfo.definingClass().isInterface() ? 185 : 182, Type.getInternalName(methodInfo.definingClass()), methodInfo.name(), Type.getMethodDescriptor((Type)Type.getType(methodInfo.rawReturnType()), (Type[])arguments), methodInfo.definingClass().isInterface());
            if (methodInfo.voidMethod()) {
                mv.visitInsn(1);
            } else if (methodInfo.rawReturnType().isPrimitive()) {
                AsmHelper.primitiveToWrapper(mv, methodInfo.rawReturnType());
            }
            mv.visitInsn(176);
            mv.visitEnd();
            mv.visitMaxs(0, 0);
            cw.visitEnd();
            Constructor<?> constructor = ClassDefiners.current().defineClass(className, methodInfo.definingClass(), cw.toByteArray()).getDeclaredConstructor(Object.class);
            constructor.setAccessible(true);
            return (MethodInvoker)constructor.newInstance(methodInfo.sourceInstance());
        }
        catch (Exception exception) {
            throw new ClassCreationException(String.format("Cannot generate rpc handler for method %s defined in class %s", methodInfo.name(), methodInfo.definingClass().getCanonicalName()), exception);
        }
    }

    @NonNull
    public MethodInvoker makeNoArgsConstructorInvoker(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        try {
            String className = String.format(NO_ARGS_CONSTRUCTOR_CLASS_NAME_FORMAT, Type.getInternalName(clazz), StringUtil.generateRandomString((int)25));
            ClassWriter cw = new ClassWriter(3);
            cw.visit(52, 17, className, null, SUPER, METHOD_INVOKER);
            MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, SUPER, "<init>", "()V", false);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            mv = cw.visitMethod(1, "callMethod", CALL_METHOD_DESCRIPTOR, null, null);
            mv.visitCode();
            mv.visitTypeInsn(187, Type.getInternalName(clazz));
            mv.visitInsn(89);
            mv.visitMethodInsn(183, Type.getInternalName(clazz), "<init>", "()V", false);
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            cw.visitEnd();
            Constructor<?> constructor = ClassDefiners.current().defineClass(className, clazz, cw.toByteArray()).getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (MethodInvoker)constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new ClassCreationException(String.format("Cannot generate rpc no args constructor for class %s", clazz.getCanonicalName()), exception);
        }
    }
}

