/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.generation;

import com.google.common.collect.ObjectArrays;
import dev.derklaro.reflexion.Reflexion;
import dev.derklaro.reflexion.matcher.ConstructorMatcher;
import eu.cloudnetservice.common.StringUtil;
import eu.cloudnetservice.driver.network.rpc.ChainableRPC;
import eu.cloudnetservice.driver.network.rpc.RPC;
import eu.cloudnetservice.driver.network.rpc.RPCChain;
import eu.cloudnetservice.driver.network.rpc.RPCSender;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.ApiImplementationGenerator;
import eu.cloudnetservice.driver.network.rpc.exception.ClassCreationException;
import eu.cloudnetservice.driver.network.rpc.generation.ChainInstanceFactory;
import eu.cloudnetservice.driver.network.rpc.generation.GenerationContext;
import eu.cloudnetservice.driver.util.asm.StackIndexHelper;
import eu.cloudnetservice.driver.util.define.ClassDefiners;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class ChainedApiImplementationGenerator {
    private static final Type RPC_TYPE = Type.getType(RPC.class);
    private static final String RPC_DESC = RPC_TYPE.getDescriptor();
    private static final Type RPC_CHAIN_TYPE = Type.getType(RPCChain.class);
    private static final String CHAINABLE_RPC_NAME = Type.getInternalName(ChainableRPC.class);
    private static final String RPC_JOIN_METHOD_DESC = Type.getMethodDescriptor((Type)RPC_CHAIN_TYPE, (Type[])new Type[]{RPC_TYPE});

    private ChainedApiImplementationGenerator() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static <T> ChainInstanceFactory<T> generateApiImplementation(@NonNull Class<T> baseClass, @NonNull GenerationContext context, @NonNull RPCSender classSender, @NonNull Function<Object[], RPC> rpcFactory) {
        if (baseClass == null) {
            throw new NullPointerException("baseClass is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (classSender == null) {
            throw new NullPointerException("classSender is marked non-null but is null");
        }
        if (rpcFactory == null) {
            throw new NullPointerException("rpcFactory is marked non-null but is null");
        }
        try {
            Class<T> parentClass = Objects.requireNonNullElse(context.extendingClass(), baseClass);
            String className = String.format("%s$Impl_%s", Type.getInternalName(parentClass), StringUtil.generateRandomString((int)10));
            String superName = context.extendingClass() == null ? "java/lang/Object" : Type.getInternalName(context.extendingClass());
            List<Class<?>> types = ChainedApiImplementationGenerator.findSuperConstructorTypes(context.extendingClass());
            String superDesc = types.stream().map(Type::getDescriptor).collect(Collectors.joining());
            ClassWriter cw = new ClassWriter(3);
            cw.visit(52, 17, className, null, superName, (String[])context.interfaces().stream().map(Type::getInternalName).toArray(String[]::new));
            cw.visitField(18, "base", RPC_DESC, null, null).visitEnd();
            cw.visitField(18, "sender", ApiImplementationGenerator.SENDER_DESC, null, null).visitEnd();
            cw.visitField(18, "channelSupplier", ApiImplementationGenerator.SUPPLIER_DESC, null, null).visitEnd();
            MethodVisitor mv = cw.visitMethod(1, "<init>", String.format("(%s%s%s%s)V", RPC_DESC, ApiImplementationGenerator.SENDER_DESC, ApiImplementationGenerator.SUPPLIER_DESC, superDesc), null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitFieldInsn(181, className, "base", RPC_DESC);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 2);
            mv.visitFieldInsn(181, className, "sender", ApiImplementationGenerator.SENDER_DESC);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 3);
            mv.visitFieldInsn(181, className, "channelSupplier", ApiImplementationGenerator.SUPPLIER_DESC);
            mv.visitVarInsn(25, 0);
            StackIndexHelper stackHelper = StackIndexHelper.create(4);
            for (Class<?> type : types) {
                stackHelper.load(mv, type);
            }
            mv.visitMethodInsn(183, superName, "<init>", "(" + superDesc + ")V", false);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            Collection<Method> methods = ApiImplementationGenerator.collectMethodsToVisit(context);
            for (Method method : methods) {
                mv = cw.visitMethod(17, method.getName(), Type.getMethodDescriptor((Method)method), null, null);
                mv.visitCode();
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, "base", RPC_DESC);
                ApiImplementationGenerator.visitInvokeMethod(className, method, mv);
                mv.visitMethodInsn(185, CHAINABLE_RPC_NAME, "join", RPC_JOIN_METHOD_DESC, true);
                ApiImplementationGenerator.visitFireMethod(method, mv, className, context);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }
            cw.visitEnd();
            Class<?> definedClass = ClassDefiners.current().defineClass(className, parentClass, cw.toByteArray());
            ConstructorMatcher constructorMatcher = (ConstructorMatcher)((ConstructorMatcher)((ConstructorMatcher)ConstructorMatcher.newMatcher().exactType(Constructor::getDeclaringClass, definedClass)).exactTypeAt(Constructor::getParameterTypes, RPC.class, 0)).exactTypeAt(Constructor::getParameterTypes, RPCSender.class, 1);
            return Reflexion.on(definedClass).findConstructor(constructorMatcher).map(accessor -> (constructorArgs, rpcArgs) -> {
                RPC baseRPC = (RPC)rpcFactory.apply(rpcArgs);
                Object[] arguments = new Object[]{baseRPC, classSender, context.channelSupplier()};
                if (constructorArgs != null) {
                    arguments = ObjectArrays.concat((Object[])arguments, (Object[])constructorArgs, Object.class);
                }
                return accessor.invokeWithArgs(arguments).getOrThrow();
            }).orElseThrow();
        }
        catch (Exception exception) {
            throw new ClassCreationException(String.format("Unable to generate api class implementation for class %s", baseClass.getName()), exception);
        }
    }

    @NonNull
    static List<Class<?>> findSuperConstructorTypes(@Nullable Class<?> extendingClass) {
        if (extendingClass == null) {
            return List.of();
        }
        return Arrays.stream(extendingClass.getConstructors()).reduce(BinaryOperator.maxBy(Comparator.comparingInt(Constructor::getParameterCount))).map(Constructor::getParameterTypes).map(List::of).orElse(List.of());
    }
}

