/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.generation;

import com.google.common.collect.ObjectArrays;
import dev.derklaro.reflexion.MethodAccessor;
import dev.derklaro.reflexion.Reflexion;
import dev.derklaro.reflexion.matcher.ConstructorMatcher;
import eu.cloudnetservice.common.StringUtil;
import eu.cloudnetservice.common.concurrent.Task;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.rpc.RPC;
import eu.cloudnetservice.driver.network.rpc.RPCExecutable;
import eu.cloudnetservice.driver.network.rpc.RPCSender;
import eu.cloudnetservice.driver.network.rpc.annotation.RPCIgnore;
import eu.cloudnetservice.driver.network.rpc.annotation.RPCNoResult;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.ChainedApiImplementationGenerator;
import eu.cloudnetservice.driver.network.rpc.exception.ClassCreationException;
import eu.cloudnetservice.driver.network.rpc.generation.GenerationContext;
import eu.cloudnetservice.driver.network.rpc.generation.InstanceFactory;
import eu.cloudnetservice.driver.util.asm.AsmHelper;
import eu.cloudnetservice.driver.util.asm.StackIndexHelper;
import eu.cloudnetservice.driver.util.define.ClassDefiners;
import jakarta.inject.Inject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class ApiImplementationGenerator {
    static final String DEFAULT_SUPER = "java/lang/Object";
    static final Type CHANNEL_TYPE = Type.getType(NetworkChannel.class);
    static final String NET_CHANNEL_TYPE = CHANNEL_TYPE.getInternalName();
    static final String SUPPLIER_DESC = Type.getDescriptor(Supplier.class);
    static final String SUPPLIER_TYPE = Type.getInternalName(Supplier.class);
    static final String GET_METHOD_DESC = Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[0]);
    static final String SENDER_DESC = Type.getDescriptor(RPCSender.class);
    static final String SENDER_TYPE = Type.getInternalName(RPCSender.class);
    static final String INVOKE_METHOD_DESC = Type.getMethodDescriptor((Type)Type.getType(RPC.class), (Type[])new Type[]{Type.getType(String.class), Type.getType(Object[].class)});
    static final String INJECT_ANNOTATION_DESC = Type.getDescriptor(Inject.class);
    static final String EXECUTABLE_NAME = Type.getInternalName(RPCExecutable.class);
    static final String EXECUTABLE_FIRE_FORGET = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]);
    static final String EXECUTABLE_FIRE = Type.getMethodDescriptor((Type)Type.getType(Task.class), (Type[])new Type[0]);
    static final String EXECUTABLE_FIRE_SYNC = Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[0]);
    static final String EXECUTABLE_FIRE_FORGET_CHANNEL = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{CHANNEL_TYPE});
    static final String EXECUTABLE_FIRE_CHANNEL = Type.getMethodDescriptor((Type)Type.getType(Task.class), (Type[])new Type[]{CHANNEL_TYPE});
    static final String EXECUTABLE_FIRE_SYNC_CHANNEL = Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{CHANNEL_TYPE});
    static final String GENERATED_CLASS_NAME_FORMAT = "%s$Impl_%s";
    static final Predicate<Method> SHOULD_GENERATE_IMPL = method -> {
        int mod = method.getModifiers();
        return Modifier.isPublic(mod) && !Modifier.isStatic(mod) && !Modifier.isFinal(mod) && !method.isBridge() && !method.isAnnotationPresent(RPCIgnore.class);
    };

    private ApiImplementationGenerator() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static <T> InstanceFactory<T> generateApiImplementation(@NonNull Class<T> baseClass, @NonNull GenerationContext context, @NonNull RPCSender sender) {
        if (baseClass == null) {
            throw new NullPointerException("baseClass is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        try {
            Class<T> parentClass = Objects.requireNonNullElse(context.extendingClass(), baseClass);
            String className = String.format(GENERATED_CLASS_NAME_FORMAT, Type.getInternalName(parentClass), StringUtil.generateRandomString((int)10));
            String superName = context.extendingClass() == null ? DEFAULT_SUPER : Type.getInternalName(context.extendingClass());
            ClassWriter cw = new ClassWriter(3);
            cw.visit(52, 17, className, null, superName, (String[])context.interfaces().stream().map(Type::getInternalName).toArray(String[]::new));
            cw.visitField(18, "sender", SENDER_DESC, null, null).visitEnd();
            cw.visitField(18, "channelSupplier", SUPPLIER_DESC, null, null).visitEnd();
            List<Class<?>> targetConstructorArgs = ChainedApiImplementationGenerator.findSuperConstructorTypes(context.extendingClass());
            MethodVisitor mv = cw.visitMethod(1, "<init>", String.format("(%s%s%s)V", SENDER_DESC, SUPPLIER_DESC, targetConstructorArgs.stream().map(Type::getDescriptor).filter(type -> !type.equals(SENDER_DESC) && !type.equals(SUPPLIER_DESC)).collect(Collectors.joining())), null, null);
            mv.visitAnnotation(INJECT_ANNOTATION_DESC, true);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            if (targetConstructorArgs.isEmpty()) {
                mv.visitMethodInsn(183, superName, "<init>", "()V", false);
            } else {
                StackIndexHelper stackHelper = StackIndexHelper.create(3);
                for (int i = 0; i < targetConstructorArgs.size(); ++i) {
                    Class<?> argumentType = targetConstructorArgs.get(i);
                    if (i == 0 && argumentType.equals(RPCSender.class)) {
                        mv.visitVarInsn(25, 1);
                        continue;
                    }
                    if ((i == 0 || i == 1) && argumentType.equals(Supplier.class)) {
                        mv.visitVarInsn(25, 2);
                        continue;
                    }
                    stackHelper.load(mv, argumentType);
                }
                mv.visitMethodInsn(183, superName, "<init>", targetConstructorArgs.stream().map(Type::getDescriptor).collect(Collectors.joining("", "(", ")V")), false);
            }
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitFieldInsn(181, className, "sender", SENDER_DESC);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 2);
            mv.visitFieldInsn(181, className, "channelSupplier", SUPPLIER_DESC);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            Collection<Method> methods = ApiImplementationGenerator.collectMethodsToVisit(context);
            for (Method method : methods) {
                mv = cw.visitMethod(17, method.getName(), Type.getMethodDescriptor((Method)method), null, null);
                mv.visitCode();
                ApiImplementationGenerator.visitInvokeMethod(className, method, mv);
                ApiImplementationGenerator.visitFireMethod(method, mv, className, context);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }
            cw.visitEnd();
            Class<?> definedClass = ClassDefiners.current().defineClass(className, parentClass, cw.toByteArray());
            ConstructorMatcher constructorMatcher = (ConstructorMatcher)((ConstructorMatcher)((ConstructorMatcher)ConstructorMatcher.newMatcher().exactType(Constructor::getDeclaringClass, definedClass)).exactTypeAt(Constructor::getParameterTypes, RPCSender.class, 0)).exactTypeAt(Constructor::getParameterTypes, Supplier.class, 1);
            MethodAccessor accessor = (MethodAccessor)Reflexion.on(definedClass).findConstructor(constructorMatcher).orElseThrow();
            return constructorArgs -> {
                Object[] arguments = ObjectArrays.concat((Object[])new Object[]{sender, context.channelSupplier()}, (Object[])constructorArgs, Object.class);
                return accessor.invokeWithArgs(arguments).getOrThrow();
            };
        }
        catch (Exception exception) {
            throw new ClassCreationException(String.format("Unable to generate api class implementation for class %s", baseClass.getName()), exception);
        }
    }

    static void visitInvokeMethod(@NonNull String className, @NonNull Method method, @NonNull MethodVisitor mv) {
        if (className == null) {
            throw new NullPointerException("className is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mv == null) {
            throw new NullPointerException("mv is marked non-null but is null");
        }
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, "sender", SENDER_DESC);
        mv.visitLdcInsn((Object)method.getName());
        Class<?>[] params = method.getParameterTypes();
        AsmHelper.pushInt(mv, params.length);
        mv.visitTypeInsn(189, DEFAULT_SUPER);
        StackIndexHelper stackHelper = StackIndexHelper.create().skipNext();
        for (int i = 0; i < params.length; ++i) {
            Class<?> paramType = params[i];
            mv.visitInsn(89);
            AsmHelper.pushInt(mv, i);
            stackHelper.load(mv, paramType);
            if (paramType.isPrimitive()) {
                AsmHelper.primitiveToWrapper(mv, paramType);
            }
            mv.visitInsn(83);
        }
        mv.visitMethodInsn(185, SENDER_TYPE, "invokeMethod", INVOKE_METHOD_DESC, true);
    }

    static void visitFireMethod(@NonNull Method method, @NonNull MethodVisitor mv, @NonNull String className, @NonNull GenerationContext context) {
        boolean voidMethod;
        boolean hasChannelSupplier;
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mv == null) {
            throw new NullPointerException("mv is marked non-null but is null");
        }
        if (className == null) {
            throw new NullPointerException("className is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        boolean bl = hasChannelSupplier = context.channelSupplier() != null;
        if (hasChannelSupplier) {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, "channelSupplier", SUPPLIER_DESC);
            mv.visitMethodInsn(185, SUPPLIER_TYPE, "get", GET_METHOD_DESC, true);
            mv.visitTypeInsn(192, NET_CHANNEL_TYPE);
        }
        if (!(voidMethod = method.getReturnType().equals(Void.TYPE)) || !method.isAnnotationPresent(RPCNoResult.class)) {
            if (Task.class.isAssignableFrom(method.getReturnType())) {
                mv.visitMethodInsn(185, EXECUTABLE_NAME, "fire", hasChannelSupplier ? EXECUTABLE_FIRE_CHANNEL : EXECUTABLE_FIRE, true);
            } else {
                mv.visitMethodInsn(185, EXECUTABLE_NAME, "fireSync", hasChannelSupplier ? EXECUTABLE_FIRE_SYNC_CHANNEL : EXECUTABLE_FIRE_SYNC, true);
                if (!voidMethod) {
                    if (method.getReturnType().isPrimitive()) {
                        AsmHelper.wrapperToPrimitive(mv, method.getReturnType());
                    } else {
                        mv.visitTypeInsn(192, Type.getInternalName(method.getReturnType()));
                    }
                }
            }
            if (voidMethod) {
                mv.visitInsn(87);
                mv.visitInsn(177);
            } else {
                Type rt = Type.getType(method.getReturnType());
                mv.visitInsn(rt.getOpcode(172));
            }
        } else {
            mv.visitMethodInsn(185, EXECUTABLE_NAME, "fireAndForget", hasChannelSupplier ? EXECUTABLE_FIRE_FORGET_CHANNEL : EXECUTABLE_FIRE_FORGET, true);
            mv.visitInsn(177);
        }
    }

    @NonNull
    static Collection<Method> collectMethodsToVisit(@NonNull GenerationContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        HashMap visitedMethods = new HashMap();
        if (context.extendingClass() != null) {
            ApiImplementationGenerator.travelClassHierarchy(context.extendingClass(), method -> {
                String id = String.format("%s@%s", method.getName(), Type.getMethodDescriptor((Method)method));
                visitedMethods.putIfAbsent(id, method);
            });
        }
        for (Class<?> inter : context.interfaces()) {
            ApiImplementationGenerator.travelClassHierarchy(inter, method -> {
                String id = String.format("%s@%s", method.getName(), Type.getMethodDescriptor((Method)method));
                visitedMethods.putIfAbsent(id, method);
            });
        }
        if (context.implementAllMethods()) {
            return visitedMethods.values();
        }
        return visitedMethods.values().stream().filter(method -> Modifier.isAbstract(method.getModifiers())).toList();
    }

    private static void travelClassHierarchy(@NonNull Class<?> start, @NonNull Consumer<Method> handler) {
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (handler == null) {
            throw new NullPointerException("handler is marked non-null but is null");
        }
        Class<?> curr = start;
        do {
            for (Method method : curr.getDeclaredMethods()) {
                if (!SHOULD_GENERATE_IMPL.test(method)) continue;
                handler.accept(method);
            }
            ApiImplementationGenerator.travelInterfaces(curr, handler);
        } while ((curr = curr.getSuperclass()) != null && curr != Object.class);
    }

    private static void travelInterfaces(@NonNull Class<?> start, @NonNull Consumer<Method> handler) {
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (handler == null) {
            throw new NullPointerException("handler is marked non-null but is null");
        }
        for (Class<?> inter : start.getInterfaces()) {
            for (Method method : inter.getDeclaredMethods()) {
                if (!SHOULD_GENERATE_IMPL.test(method)) continue;
                handler.accept(method);
            }
        }
    }
}

