/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import dev.derklaro.aerogel.auto.Provides;
import eu.cloudnetservice.driver.network.NetworkComponent;
import eu.cloudnetservice.driver.network.buffer.DataBufFactory;
import eu.cloudnetservice.driver.network.rpc.RPCFactory;
import eu.cloudnetservice.driver.network.rpc.RPCHandler;
import eu.cloudnetservice.driver.network.rpc.RPCSender;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.ApiImplementationGenerator;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.ChainedApiImplementationGenerator;
import eu.cloudnetservice.driver.network.rpc.defaults.handler.DefaultRPCHandler;
import eu.cloudnetservice.driver.network.rpc.defaults.sender.DefaultRPCSender;
import eu.cloudnetservice.driver.network.rpc.generation.ChainInstanceFactory;
import eu.cloudnetservice.driver.network.rpc.generation.GenerationContext;
import eu.cloudnetservice.driver.network.rpc.generation.InstanceFactory;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Objects;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Provides(value={RPCFactory.class})
public class DefaultRPCFactory
implements RPCFactory {
    protected final ObjectMapper defaultObjectMapper;
    protected final DataBufFactory defaultDataBufFactory;
    protected final Cache<GenerationContext, InstanceFactory<?>> generatedApiCache = Caffeine.newBuilder().build();
    protected final Table<String, GenerationContext, ChainInstanceFactory<?>> chainFactoryCache = HashBasedTable.create();

    @Inject
    public DefaultRPCFactory(@NonNull ObjectMapper defaultObjectMapper, @NonNull DataBufFactory defaultDataBufFactory) {
        if (defaultObjectMapper == null) {
            throw new NullPointerException("defaultObjectMapper is marked non-null but is null");
        }
        if (defaultDataBufFactory == null) {
            throw new NullPointerException("defaultDataBufFactory is marked non-null but is null");
        }
        this.defaultObjectMapper = defaultObjectMapper;
        this.defaultDataBufFactory = defaultDataBufFactory;
    }

    @Override
    @NonNull
    public ObjectMapper defaultObjectMapper() {
        return this.defaultObjectMapper;
    }

    @Override
    @NonNull
    public DataBufFactory defaultDataBufFactory() {
        return this.defaultDataBufFactory;
    }

    @Override
    @NonNull
    public RPCSender providerForClass(@Nullable NetworkComponent component, @NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.providerForClass(component, clazz, this.defaultObjectMapper, this.defaultDataBufFactory);
    }

    @Override
    @NonNull
    public RPCSender providerForClass(@Nullable NetworkComponent component, @NonNull Class<?> clazz, @NonNull ObjectMapper objectMapper, @NonNull DataBufFactory dataBufFactory) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (dataBufFactory == null) {
            throw new NullPointerException("dataBufFactory is marked non-null but is null");
        }
        return new DefaultRPCSender(this, component, clazz, objectMapper, dataBufFactory);
    }

    @Override
    @NonNull
    public <T> InstanceFactory<T> generateRPCBasedApi(@NonNull Class<T> baseClass, @NonNull GenerationContext context) {
        if (baseClass == null) {
            throw new NullPointerException("baseClass is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        return (InstanceFactory)this.generatedApiCache.get((Object)context, $ -> {
            RPCSender sender = this.senderFromGenerationContext(context, baseClass);
            return ApiImplementationGenerator.generateApiImplementation(baseClass, context, sender);
        });
    }

    @Override
    @NonNull
    public <T> ChainInstanceFactory<T> generateRPCChainBasedApi(@NonNull RPCSender baseSender, @NonNull Class<T> chainBaseClass, @NonNull GenerationContext context) {
        if (baseSender == null) {
            throw new NullPointerException("baseSender is marked non-null but is null");
        }
        if (chainBaseClass == null) {
            throw new NullPointerException("chainBaseClass is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        return this.generateRPCChainBasedApi(baseSender, StackWalker.getInstance().walk(stream -> stream.skip(1L).map(StackWalker.StackFrame::getMethodName).findFirst().orElseThrow()), chainBaseClass, context);
    }

    @Override
    @NonNull
    public <T> ChainInstanceFactory<T> generateRPCChainBasedApi(@NonNull RPCSender baseSender, @NonNull String baseCallerMethod, @NonNull Class<T> chainBaseClass, @NonNull GenerationContext context) {
        if (baseSender == null) {
            throw new NullPointerException("baseSender is marked non-null but is null");
        }
        if (baseCallerMethod == null) {
            throw new NullPointerException("baseCallerMethod is marked non-null but is null");
        }
        if (chainBaseClass == null) {
            throw new NullPointerException("chainBaseClass is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        ChainInstanceFactory<T> factory = (ChainInstanceFactory<T>)this.chainFactoryCache.get((Object)baseCallerMethod, (Object)context);
        if (factory == null) {
            factory = ChainedApiImplementationGenerator.generateApiImplementation(chainBaseClass, context, this.senderFromGenerationContext(context, chainBaseClass), args -> baseSender.invokeMethod(baseCallerMethod, args));
            this.chainFactoryCache.put((Object)baseCallerMethod, (Object)context, factory);
        }
        return factory;
    }

    @Override
    @NonNull
    public RPCHandler newHandler(@NonNull Class<?> clazz, @Nullable Object binding) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.newHandler(clazz, binding, this.defaultObjectMapper, this.defaultDataBufFactory);
    }

    @Override
    @NonNull
    public RPCHandler newHandler(@NonNull Class<?> clazz, @Nullable Object binding, @NonNull ObjectMapper objectMapper, @NonNull DataBufFactory dataBufFactory) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (dataBufFactory == null) {
            throw new NullPointerException("dataBufFactory is marked non-null but is null");
        }
        return new DefaultRPCHandler(clazz, binding, objectMapper, dataBufFactory);
    }

    @NonNull
    private RPCSender senderFromGenerationContext(@NonNull GenerationContext context, @NonNull Class<?> base) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (base == null) {
            throw new NullPointerException("base is marked non-null but is null");
        }
        ObjectMapper objectMapper = Objects.requireNonNullElse(context.objectMapper(), this.defaultObjectMapper);
        DataBufFactory dataBufFactory = Objects.requireNonNullElse(context.dataBufFactory(), this.defaultDataBufFactory);
        return this.providerForClass(context.component(), base, objectMapper, dataBufFactory);
    }
}

