/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.protocol.defaults;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Scheduler;
import eu.cloudnetservice.common.concurrent.Task;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.protocol.Packet;
import eu.cloudnetservice.driver.network.protocol.QueryPacketManager;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class DefaultQueryPacketManager
implements QueryPacketManager {
    private static final Duration DEFAULT_TIMEOUT_DURATION = Duration.ofSeconds(30L);
    private final Duration queryTimeout;
    private final NetworkChannel networkChannel;
    private final Cache<UUID, Task<Packet>> waitingHandlers;

    public DefaultQueryPacketManager(@NonNull NetworkChannel networkChannel) {
        this(networkChannel, DEFAULT_TIMEOUT_DURATION);
        if (networkChannel == null) {
            throw new NullPointerException("networkChannel is marked non-null but is null");
        }
    }

    public DefaultQueryPacketManager(@NonNull NetworkChannel networkChannel, @NonNull Duration queryTimeout) {
        if (networkChannel == null) {
            throw new NullPointerException("networkChannel is marked non-null but is null");
        }
        if (queryTimeout == null) {
            throw new NullPointerException("queryTimeout is marked non-null but is null");
        }
        this.networkChannel = networkChannel;
        this.queryTimeout = queryTimeout;
        this.waitingHandlers = Caffeine.newBuilder().expireAfterWrite(queryTimeout).scheduler(Scheduler.systemScheduler()).removalListener(this.newRemovalListener()).build();
    }

    @Override
    @NonNull
    public Duration queryTimeout() {
        return this.queryTimeout;
    }

    @Override
    @NonNull
    public NetworkChannel networkChannel() {
        return this.networkChannel;
    }

    @Override
    @NonNull
    public @UnmodifiableView Map<UUID, Task<Packet>> waitingHandlers() {
        return Collections.unmodifiableMap(this.waitingHandlers.asMap());
    }

    @Override
    public boolean hasWaitingHandler(@NonNull UUID queryUniqueId) {
        if (queryUniqueId == null) {
            throw new NullPointerException("queryUniqueId is marked non-null but is null");
        }
        return this.waitingHandlers.getIfPresent((Object)queryUniqueId) != null;
    }

    @Override
    public boolean unregisterWaitingHandler(@NonNull UUID queryUniqueId) {
        if (queryUniqueId == null) {
            throw new NullPointerException("queryUniqueId is marked non-null but is null");
        }
        this.waitingHandlers.invalidate((Object)queryUniqueId);
        return true;
    }

    @Override
    @Nullable
    public Task<Packet> waitingHandler(@NonNull UUID queryUniqueId) {
        if (queryUniqueId == null) {
            throw new NullPointerException("queryUniqueId is marked non-null but is null");
        }
        Task task = (Task)this.waitingHandlers.getIfPresent((Object)queryUniqueId);
        if (task != null) {
            this.waitingHandlers.invalidate((Object)queryUniqueId);
        }
        return task;
    }

    @Override
    @NonNull
    public Task<Packet> sendQueryPacket(@NonNull Packet packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        return this.sendQueryPacket(packet, UUID.randomUUID());
    }

    @Override
    @NonNull
    public Task<Packet> sendQueryPacket(@NonNull Packet packet, @NonNull UUID queryUniqueId) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        if (queryUniqueId == null) {
            throw new NullPointerException("queryUniqueId is marked non-null but is null");
        }
        Task task = new Task();
        this.waitingHandlers.put((Object)queryUniqueId, (Object)task);
        packet.uniqueId(queryUniqueId);
        this.networkChannel.sendPacketSync(packet);
        return task;
    }

    @NonNull
    protected RemovalListener<UUID, Task<Packet>> newRemovalListener() {
        return ($, value, cause) -> {
            if (cause.wasEvicted() && value != null) {
                value.completeExceptionally((Throwable)new TimeoutException());
            }
        };
    }
}

