/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.protocol;

import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.protocol.Packet;
import java.time.Instant;
import java.util.UUID;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class BasePacket
implements Packet {
    protected final int channel;
    protected final DataBuf dataBuf;
    protected final boolean prioritized;
    protected final Instant creationStamp;
    protected UUID uniqueId;

    public BasePacket(int channel, @NonNull DataBuf dataBuf) {
        this(channel, false, dataBuf);
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
    }

    public BasePacket(int channel, boolean prioritized, @NonNull DataBuf dataBuf) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        this.channel = channel;
        this.dataBuf = dataBuf;
        this.prioritized = prioritized;
        this.creationStamp = Instant.now();
    }

    @Override
    @NonNull
    public Packet constructResponse(@NonNull DataBuf content) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        BasePacket packet = new BasePacket(-1, content);
        packet.uniqueId(this.uniqueId());
        return packet;
    }

    @Override
    @Nullable
    public UUID uniqueId() {
        return this.uniqueId;
    }

    @Override
    public void uniqueId(@Nullable UUID uniqueId) {
        this.uniqueId = uniqueId;
    }

    @Override
    public int channel() {
        return this.channel;
    }

    @Override
    public boolean prioritized() {
        return this.prioritized;
    }

    @Override
    public boolean readable() {
        return this.dataBuf.accessible() && this.dataBuf.readableBytes() > 0;
    }

    @Override
    @NonNull
    public DataBuf content() {
        return this.dataBuf;
    }

    @Override
    @NonNull
    public Instant creation() {
        return this.creationStamp;
    }

    public String toString() {
        return "BasePacket(channel=" + this.channel + ", dataBuf=" + this.dataBuf + ", prioritized=" + this.prioritized + ", creationStamp=" + this.creationStamp + ", uniqueId=" + this.uniqueId + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasePacket)) {
            return false;
        }
        BasePacket other = (BasePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.channel != other.channel) {
            return false;
        }
        if (this.prioritized != other.prioritized) {
            return false;
        }
        DataBuf this$dataBuf = this.dataBuf;
        DataBuf other$dataBuf = other.dataBuf;
        if (this$dataBuf == null ? other$dataBuf != null : !this$dataBuf.equals(other$dataBuf)) {
            return false;
        }
        Instant this$creationStamp = this.creationStamp;
        Instant other$creationStamp = other.creationStamp;
        if (this$creationStamp == null ? other$creationStamp != null : !((Object)this$creationStamp).equals(other$creationStamp)) {
            return false;
        }
        UUID this$uniqueId = this.uniqueId;
        UUID other$uniqueId = other.uniqueId;
        return !(this$uniqueId == null ? other$uniqueId != null : !((Object)this$uniqueId).equals(other$uniqueId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BasePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.channel;
        result = result * 59 + (this.prioritized ? 79 : 97);
        DataBuf $dataBuf = this.dataBuf;
        result = result * 59 + ($dataBuf == null ? 43 : $dataBuf.hashCode());
        Instant $creationStamp = this.creationStamp;
        result = result * 59 + ($creationStamp == null ? 43 : ((Object)$creationStamp).hashCode());
        UUID $uniqueId = this.uniqueId;
        result = result * 59 + ($uniqueId == null ? 43 : ((Object)$uniqueId).hashCode());
        return result;
    }
}

