/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty.http;

import eu.cloudnetservice.driver.network.http.HttpChannel;
import eu.cloudnetservice.driver.network.http.websocket.WebSocketChannel;
import eu.cloudnetservice.driver.network.http.websocket.WebSocketFrameType;
import eu.cloudnetservice.driver.network.http.websocket.WebSocketListener;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelFutureListeners;
import io.netty5.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.TextWebSocketFrame;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

final class NettyWebSocketServerChannel
implements WebSocketChannel {
    private final Collection<WebSocketListener> webSocketListeners = ConcurrentHashMap.newKeySet();
    private final Channel channel;
    private final HttpChannel httpChannel;

    public NettyWebSocketServerChannel(@NonNull HttpChannel httpChannel, @NonNull Channel channel) {
        if (httpChannel == null) {
            throw new NullPointerException("httpChannel is marked non-null but is null");
        }
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        this.httpChannel = httpChannel;
        this.channel = channel;
    }

    @Override
    @NonNull
    public WebSocketChannel addListener(WebSocketListener ... listeners) {
        if (listeners == null) {
            throw new NullPointerException("listeners is marked non-null but is null");
        }
        this.webSocketListeners.addAll(Arrays.asList(listeners));
        return this;
    }

    @Override
    @NonNull
    public WebSocketChannel removeListener(WebSocketListener ... listeners) {
        if (listeners == null) {
            throw new NullPointerException("listeners is marked non-null but is null");
        }
        this.webSocketListeners.removeIf(listener -> Arrays.asList(listeners).contains(listener));
        return this;
    }

    @Override
    @NonNull
    public WebSocketChannel removeListener(@NonNull ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("classLoader is marked non-null but is null");
        }
        this.webSocketListeners.removeIf(listener -> listener.getClass().getClassLoader().equals(classLoader));
        return this;
    }

    @Override
    @NonNull
    public WebSocketChannel clearListeners() {
        this.webSocketListeners.clear();
        return this;
    }

    @Override
    @NonNull
    public Collection<WebSocketListener> listeners() {
        return this.webSocketListeners;
    }

    @Override
    @NonNull
    public WebSocketChannel sendWebSocketFrame(@NonNull WebSocketFrameType type, @NonNull String text) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return this.sendWebSocketFrame(type, text.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    @NonNull
    public WebSocketChannel sendWebSocketFrame(@NonNull WebSocketFrameType webSocketFrameType, byte[] bytes) {
        if (webSocketFrameType == null) {
            throw new NullPointerException("webSocketFrameType is marked non-null but is null");
        }
        Buffer binaryData = DefaultBufferAllocators.offHeapAllocator().copyOf(bytes);
        PingWebSocketFrame webSocketFrame = switch (webSocketFrameType) {
            case WebSocketFrameType.PING -> new PingWebSocketFrame(binaryData);
            case WebSocketFrameType.PONG -> new PongWebSocketFrame(binaryData);
            case WebSocketFrameType.TEXT -> new TextWebSocketFrame(binaryData);
            default -> new BinaryWebSocketFrame(binaryData);
        };
        this.channel.writeAndFlush((Object)webSocketFrame).addListener((Object)this.channel, ChannelFutureListeners.FIRE_EXCEPTION_ON_FAILURE);
        return this;
    }

    @Override
    @NonNull
    public HttpChannel channel() {
        return this.httpChannel;
    }

    @Override
    public void close(int statusCode, @Nullable String reasonText) {
        AtomicInteger statusCodeReference = new AtomicInteger(statusCode);
        AtomicReference<String> reasonTextReference = new AtomicReference<String>(reasonText);
        for (WebSocketListener listener : this.webSocketListeners) {
            listener.handleClose(this, statusCodeReference, reasonTextReference);
        }
        this.channel.writeAndFlush((Object)new CloseWebSocketFrame(DefaultBufferAllocators.offHeapAllocator(), statusCodeReference.get(), reasonTextReference.get())).addListener((Object)this.channel, ChannelFutureListeners.CLOSE);
    }

    @Override
    public void close() {
        this.close(1000, "goodbye");
    }
}

