/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty.http;

import com.google.common.primitives.Ints;
import eu.cloudnetservice.driver.network.http.HttpContext;
import eu.cloudnetservice.driver.network.http.HttpRequest;
import eu.cloudnetservice.driver.network.http.HttpVersion;
import eu.cloudnetservice.driver.network.netty.http.NettyHttpMessage;
import eu.cloudnetservice.driver.network.netty.http.NettyHttpServerContext;
import io.netty5.buffer.BufferInputStream;
import io.netty5.handler.codec.http.FullHttpRequest;
import io.netty5.handler.codec.http.QueryStringDecoder;
import io.netty5.handler.codec.http.headers.HttpHeaders;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

final class NettyHttpServerRequest
extends NettyHttpMessage
implements HttpRequest {
    private final NettyHttpServerContext context;
    private final URI uri;
    private final io.netty5.handler.codec.http.HttpRequest httpRequest;
    private final Map<String, String> pathParameters;
    private final Map<String, List<String>> queryParameters;
    private byte[] body;

    public NettyHttpServerRequest(@NonNull NettyHttpServerContext context, @NonNull io.netty5.handler.codec.http.HttpRequest httpRequest, @NonNull Map<String, String> pathParameters, @NonNull URI uri) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (httpRequest == null) {
            throw new NullPointerException("httpRequest is marked non-null but is null");
        }
        if (pathParameters == null) {
            throw new NullPointerException("pathParameters is marked non-null but is null");
        }
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        this.context = context;
        this.httpRequest = httpRequest;
        this.uri = uri;
        this.pathParameters = pathParameters;
        this.queryParameters = new QueryStringDecoder(httpRequest.uri()).parameters();
    }

    @Override
    @NonNull
    public Map<String, String> pathParameters() {
        return this.pathParameters;
    }

    @Override
    @NonNull
    public String path() {
        return this.uri.getPath();
    }

    @Override
    @NonNull
    public String uri() {
        return this.httpRequest.uri();
    }

    @Override
    @NonNull
    public String method() {
        return this.httpRequest.method().name();
    }

    @Override
    @NonNull
    public Map<String, List<String>> queryParameters() {
        return this.queryParameters;
    }

    @Override
    @NonNull
    public HttpContext context() {
        return this.context;
    }

    @Override
    @Nullable
    public String header(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        CharSequence headerValue = this.httpRequest.headers().get((CharSequence)name);
        return headerValue == null ? null : headerValue.toString();
    }

    @Override
    @Nullable
    public Integer headerAsInt(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        String headerValue = this.header(name);
        return headerValue == null ? null : Ints.tryParse((String)headerValue);
    }

    @Override
    public boolean headerAsBoolean(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        String headerValue = this.header(name);
        return Boolean.parseBoolean(headerValue);
    }

    @Override
    @NonNull
    public HttpRequest header(@NonNull String name, @NonNull String value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.httpRequest.headers().set((CharSequence)name, (CharSequence)value);
        return this;
    }

    @Override
    @NonNull
    public HttpRequest removeHeader(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.httpRequest.headers().remove((CharSequence)name);
        return this;
    }

    @Override
    @NonNull
    public HttpRequest clearHeaders() {
        this.httpRequest.headers().clear();
        return this;
    }

    @Override
    public boolean hasHeader(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.httpRequest.headers().contains((CharSequence)name);
    }

    @Override
    @NonNull
    public Map<String, String> headers() {
        HttpHeaders headers = this.httpRequest.headers();
        HashMap<String, String> headerMap = new HashMap<String, String>(headers.size() + 1, 1.0f);
        for (Map.Entry entry : headers) {
            headerMap.put(((CharSequence)entry.getKey()).toString(), ((CharSequence)entry.getValue()).toString());
        }
        return headerMap;
    }

    @Override
    @NonNull
    public HttpVersion version() {
        return super.versionFromNetty(this.httpRequest.protocolVersion());
    }

    @Override
    @NonNull
    public HttpRequest version(@NonNull HttpVersion version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        this.httpRequest.setProtocolVersion(super.versionToNetty(version));
        return this;
    }

    @Override
    public byte[] body() {
        io.netty5.handler.codec.http.HttpRequest httpRequest = this.httpRequest;
        if (httpRequest instanceof FullHttpRequest) {
            FullHttpRequest request = (FullHttpRequest)httpRequest;
            if (this.body == null) {
                int length = request.payload().readableBytes();
                this.body = new byte[length];
                request.payload().copyInto(request.payload().readerOffset(), this.body, 0, length);
            }
            return this.body;
        }
        return new byte[0];
    }

    @Override
    @NonNull
    public String bodyAsString() {
        return new String(this.body(), StandardCharsets.UTF_8);
    }

    @Override
    @NonNull
    public HttpRequest body(byte[] byteArray) {
        throw new UnsupportedOperationException("Unable to set body in request");
    }

    @Override
    @NonNull
    public HttpRequest body(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return this.body(text.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    @Nullable
    public InputStream bodyStream() {
        io.netty5.handler.codec.http.HttpRequest httpRequest = this.httpRequest;
        if (httpRequest instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)httpRequest;
            return new BufferInputStream(fullHttpRequest.payload().send());
        }
        return null;
    }

    @Override
    @NonNull
    public HttpRequest body(@Nullable InputStream body) {
        throw new UnsupportedOperationException("Unable to set body in request");
    }

    @Override
    public boolean hasBody() {
        FullHttpRequest request;
        io.netty5.handler.codec.http.HttpRequest httpRequest = this.httpRequest;
        return httpRequest instanceof FullHttpRequest && (request = (FullHttpRequest)httpRequest).payload().readableBytes() > 0;
    }
}

