/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty.http;

import eu.cloudnetservice.driver.network.HostAndPort;
import eu.cloudnetservice.driver.network.netty.http.NettyHttpServer;
import eu.cloudnetservice.driver.network.netty.http.NettyHttpServerHandler;
import eu.cloudnetservice.driver.network.netty.http.NettyIdleStateHandler;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelInitializer;
import io.netty5.handler.codec.http.HttpContentCompressor;
import io.netty5.handler.codec.http.HttpObjectAggregator;
import io.netty5.handler.codec.http.HttpRequestDecoder;
import io.netty5.handler.codec.http.HttpResponseEncoder;
import io.netty5.handler.stream.ChunkedWriteHandler;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
final class NettyHttpServerInitializer
extends ChannelInitializer<Channel> {
    private final NettyHttpServer nettyHttpServer;
    private final HostAndPort hostAndPort;

    public NettyHttpServerInitializer(@NonNull NettyHttpServer nettyHttpServer, @NonNull HostAndPort hostAndPort) {
        if (nettyHttpServer == null) {
            throw new NullPointerException("nettyHttpServer is marked non-null but is null");
        }
        if (hostAndPort == null) {
            throw new NullPointerException("hostAndPort is marked non-null but is null");
        }
        this.nettyHttpServer = nettyHttpServer;
        this.hostAndPort = hostAndPort;
    }

    protected void initChannel(@NonNull Channel ch) {
        if (ch == null) {
            throw new NullPointerException("ch is marked non-null but is null");
        }
        if (this.nettyHttpServer.sslContext != null) {
            ch.pipeline().addLast("ssl-handler", (ChannelHandler)this.nettyHttpServer.sslContext.newHandler(ch.bufferAllocator()));
        }
        ch.pipeline().addLast("read-timeout-handler", (ChannelHandler)new NettyIdleStateHandler(30)).addLast("http-request-decoder", (ChannelHandler)new HttpRequestDecoder()).addLast("http-object-aggregator", (ChannelHandler)new HttpObjectAggregator(Short.MAX_VALUE)).addLast("http-response-encoder", (ChannelHandler)new HttpResponseEncoder()).addLast("http-response-compressor", (ChannelHandler)new HttpContentCompressor()).addLast("http-chunk-handler", (ChannelHandler)new ChunkedWriteHandler()).addLast("http-server-handler", (ChannelHandler)new NettyHttpServerHandler(this.nettyHttpServer, this.hostAndPort));
    }
}

