/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty.http;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import eu.cloudnetservice.common.concurrent.Task;
import eu.cloudnetservice.driver.network.http.HttpChannel;
import eu.cloudnetservice.driver.network.http.HttpComponent;
import eu.cloudnetservice.driver.network.http.HttpContext;
import eu.cloudnetservice.driver.network.http.HttpCookie;
import eu.cloudnetservice.driver.network.http.HttpHandler;
import eu.cloudnetservice.driver.network.http.HttpRequest;
import eu.cloudnetservice.driver.network.http.HttpResponse;
import eu.cloudnetservice.driver.network.http.HttpServer;
import eu.cloudnetservice.driver.network.http.websocket.WebSocketChannel;
import eu.cloudnetservice.driver.network.netty.http.NettyHttpChannel;
import eu.cloudnetservice.driver.network.netty.http.NettyHttpServer;
import eu.cloudnetservice.driver.network.netty.http.NettyHttpServerRequest;
import eu.cloudnetservice.driver.network.netty.http.NettyHttpServerResponse;
import eu.cloudnetservice.driver.network.netty.http.NettyWebSocketServerChannel;
import eu.cloudnetservice.driver.network.netty.http.NettyWebSocketServerChannelHandler;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.handler.codec.http.DefaultFullHttpResponse;
import io.netty5.handler.codec.http.HttpResponseStatus;
import io.netty5.handler.codec.http.headers.DefaultHttpSetCookie;
import io.netty5.handler.codec.http.headers.HttpCookiePair;
import io.netty5.handler.codec.http.headers.HttpSetCookie;
import io.netty5.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty5.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

final class NettyHttpServerContext
implements HttpContext {
    final NettyHttpServerResponse httpServerResponse;
    final Multimap<String, Object> invocationHints = ArrayListMultimap.create();
    private final Channel nettyChannel;
    private final io.netty5.handler.codec.http.HttpRequest httpRequest;
    private final NettyHttpChannel channel;
    private final NettyHttpServer nettyHttpServer;
    private final NettyHttpServerRequest httpServerRequest;
    private final Collection<HttpCookie> cookies = new ArrayList<HttpCookie>();
    volatile boolean closeAfter = true;
    volatile boolean cancelNext = false;
    volatile boolean cancelSendResponse = false;
    private volatile String pathPrefix;
    private volatile HttpHandler lastHandler;
    private volatile NettyWebSocketServerChannel webSocketServerChannel;

    public NettyHttpServerContext(@NonNull NettyHttpServer nettyHttpServer, @NonNull NettyHttpChannel channel, @NonNull URI uri, @NonNull Map<String, String> pathParameters, @NonNull io.netty5.handler.codec.http.HttpRequest httpRequest) {
        if (nettyHttpServer == null) {
            throw new NullPointerException("nettyHttpServer is marked non-null but is null");
        }
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        if (pathParameters == null) {
            throw new NullPointerException("pathParameters is marked non-null but is null");
        }
        if (httpRequest == null) {
            throw new NullPointerException("httpRequest is marked non-null but is null");
        }
        this.nettyHttpServer = nettyHttpServer;
        this.channel = channel;
        this.httpRequest = httpRequest;
        this.nettyChannel = channel.channel();
        this.httpServerRequest = new NettyHttpServerRequest(this, httpRequest, pathParameters, uri);
        this.httpServerResponse = new NettyHttpServerResponse(this, httpRequest);
        Iterator cookiesIterator = this.httpRequest.headers().getCookiesIterator();
        while (cookiesIterator.hasNext()) {
            HttpCookiePair cookie = (HttpCookiePair)cookiesIterator.next();
            HttpCookie httpCookie = new HttpCookie(cookie.name().toString(), cookie.value().toString(), null, null, false, false, cookie.isWrapped(), 0L);
            this.cookies.add(httpCookie);
        }
    }

    @Override
    @NonNull
    public Task<WebSocketChannel> upgrade() {
        if (this.webSocketServerChannel == null) {
            WebSocketServerHandshaker handshaker = new WebSocketServerHandshakerFactory(this.httpRequest.uri(), null, true, Short.MAX_VALUE, false).newHandshaker(this.httpRequest);
            if (handshaker == null) {
                WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)this.nettyChannel);
                return Task.completedTask((Object)new IllegalStateException("Unsupported web socket version"));
            }
            this.nettyChannel.pipeline().remove("http-server-handler");
            this.nettyChannel.pipeline().remove("read-timeout-handler");
            this.cancelNext(true);
            this.closeAfter(false);
            this.cancelSendResponse = true;
            Task task = new Task();
            handshaker.handshake(this.nettyChannel, this.httpRequest).addListener(future -> {
                if (future.isSuccess()) {
                    this.webSocketServerChannel = new NettyWebSocketServerChannel(this.channel, this.nettyChannel);
                    this.nettyChannel.pipeline().addLast("websocket-server-channel-handler", (ChannelHandler)new NettyWebSocketServerChannelHandler(this.webSocketServerChannel));
                    task.complete((Object)this.webSocketServerChannel);
                } else {
                    this.nettyChannel.writeAndFlush((Object)new DefaultFullHttpResponse(this.httpRequest.protocolVersion(), HttpResponseStatus.OK, DefaultBufferAllocators.offHeapAllocator().copyOf("Unable to upgrade connection".getBytes())));
                    task.completeExceptionally(future.cause());
                }
            });
            return task;
        }
        return Task.completedTask((Object)this.webSocketServerChannel);
    }

    @Override
    @Nullable
    public WebSocketChannel webSocketChanel() {
        return this.webSocketServerChannel;
    }

    @Override
    @NonNull
    public HttpChannel channel() {
        return this.channel;
    }

    @Override
    @NonNull
    public HttpRequest request() {
        return this.httpServerRequest;
    }

    @Override
    @NonNull
    public HttpResponse response() {
        return this.httpServerResponse;
    }

    @Override
    public boolean cancelNext() {
        this.cancelNext = true;
        return true;
    }

    @Override
    @NonNull
    public HttpContext cancelNext(boolean cancelNext) {
        this.cancelNext = cancelNext;
        return this;
    }

    @Override
    @Nullable
    public HttpHandler peekLast() {
        return this.lastHandler;
    }

    @NonNull
    public HttpComponent<HttpServer> component() {
        return this.nettyHttpServer;
    }

    @Override
    @NonNull
    public HttpContext closeAfter(boolean value) {
        this.closeAfter = value;
        return this;
    }

    @Override
    public boolean closeAfter() {
        this.closeAfter = true;
        return true;
    }

    @Override
    public HttpCookie cookie(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.cookies.stream().filter(httpCookie -> httpCookie.name().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    @Override
    @NonNull
    public Collection<HttpCookie> cookies() {
        return this.cookies;
    }

    @Override
    public boolean hasCookie(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.cookies.stream().anyMatch(httpCookie -> httpCookie.name().equalsIgnoreCase(name));
    }

    @Override
    @NonNull
    public HttpContext cookies(@NonNull Collection<HttpCookie> cookies) {
        if (cookies == null) {
            throw new NullPointerException("cookies is marked non-null but is null");
        }
        cookies.forEach(this::addCookie);
        return this;
    }

    @Override
    @NonNull
    public HttpContext addCookie(@NonNull HttpCookie httpCookie) {
        if (httpCookie == null) {
            throw new NullPointerException("httpCookie is marked non-null but is null");
        }
        DefaultHttpSetCookie cookie = new DefaultHttpSetCookie((CharSequence)httpCookie.name(), (CharSequence)httpCookie.value(), (CharSequence)httpCookie.path(), (CharSequence)httpCookie.domain(), null, Long.valueOf(httpCookie.maxAge()), null, httpCookie.wrap(), httpCookie.secure(), httpCookie.httpOnly());
        this.httpServerResponse.httpResponse.headers().addSetCookie((HttpSetCookie)cookie);
        return this;
    }

    @Override
    @NonNull
    public HttpContext removeCookie(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.httpServerResponse.httpResponse.headers().removeSetCookies((CharSequence)name);
        return this;
    }

    @Override
    @NonNull
    public HttpContext clearCookies() {
        Iterator cookieIterator = this.httpServerResponse.httpResponse.headers().getSetCookiesIterator();
        while (cookieIterator.hasNext()) {
            cookieIterator.remove();
        }
        return this;
    }

    @Override
    @NonNull
    public String pathPrefix() {
        return this.pathPrefix;
    }

    @Override
    @NonNull
    public Collection<Object> invocationHints(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.invocationHints.get((Object)key);
    }

    @Override
    @NonNull
    public HttpContext addInvocationHint(@NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.invocationHints.put((Object)key, value);
        return this;
    }

    @Override
    @NonNull
    public <T> HttpContext addInvocationHints(@NonNull String key, @NonNull Collection<T> value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.invocationHints.putAll((Object)key, value);
        return this;
    }

    public void pathPrefix(@NonNull String pathPrefix) {
        if (pathPrefix == null) {
            throw new NullPointerException("pathPrefix is marked non-null but is null");
        }
        this.pathPrefix = pathPrefix;
    }

    public void pushChain(@NonNull HttpHandler lastHandler) {
        if (lastHandler == null) {
            throw new NullPointerException("lastHandler is marked non-null but is null");
        }
        this.lastHandler = lastHandler;
    }
}

