/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty.codec;

import eu.cloudnetservice.driver.network.netty.NettyUtil;
import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.MessageToByteEncoder;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class VarInt32FramePrepender
extends MessageToByteEncoder<Buffer> {
    public static final VarInt32FramePrepender INSTANCE = new VarInt32FramePrepender();

    protected Buffer allocateBuffer(@NonNull ChannelHandlerContext ctx, @NonNull Buffer msg) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (msg == null) {
            throw new NullPointerException("msg is marked non-null but is null");
        }
        int bufferSize = NettyUtil.varIntBytes(msg.readableBytes()) + msg.readableBytes();
        return ctx.bufferAllocator().allocate(bufferSize);
    }

    protected void encode(@NonNull ChannelHandlerContext ctx, @NonNull Buffer msg, @NonNull Buffer out) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (msg == null) {
            throw new NullPointerException("msg is marked non-null but is null");
        }
        if (out == null) {
            throw new NullPointerException("out is marked non-null but is null");
        }
        NettyUtil.writeVarInt(out, msg.readableBytes());
        out.writeBytes(msg);
    }

    public boolean isSharable() {
        return true;
    }
}

