/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty.client;

import eu.cloudnetservice.common.concurrent.Task;
import eu.cloudnetservice.driver.ComponentInfo;
import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.network.DefaultNetworkComponent;
import eu.cloudnetservice.driver.network.HostAndPort;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.NetworkChannelHandler;
import eu.cloudnetservice.driver.network.NetworkClient;
import eu.cloudnetservice.driver.network.netty.NettyUtil;
import eu.cloudnetservice.driver.network.netty.client.NettyNetworkClientInitializer;
import eu.cloudnetservice.driver.network.protocol.PacketListenerRegistry;
import eu.cloudnetservice.driver.network.protocol.defaults.DefaultPacketListenerRegistry;
import eu.cloudnetservice.driver.network.ssl.SSLConfiguration;
import io.netty5.bootstrap.Bootstrap;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.WriteBufferWaterMark;
import io.netty5.handler.ssl.ClientAuth;
import io.netty5.handler.ssl.SslContext;
import io.netty5.handler.ssl.SslContextBuilder;
import io.netty5.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty5.handler.ssl.util.SelfSignedCertificate;
import jakarta.inject.Singleton;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public class NettyNetworkClient
implements DefaultNetworkComponent,
NetworkClient {
    private static final int CONNECTION_TIMEOUT_MILLIS = 5000;
    private static final WriteBufferWaterMark WATER_MARK = new WriteBufferWaterMark(0x100000, 0x200000);
    protected final EventLoopGroup eventLoopGroup = NettyUtil.newEventLoopGroup(0);
    protected final Collection<NetworkChannel> channels = ConcurrentHashMap.newKeySet();
    protected final PacketListenerRegistry packetRegistry = new DefaultPacketListenerRegistry();
    protected final EventManager eventManager;
    protected final Executor packetDispatcher;
    protected final SSLConfiguration sslConfiguration;
    protected final Callable<NetworkChannelHandler> handlerFactory;
    protected SslContext sslContext;

    public NettyNetworkClient(@NonNull EventManager eventManager, @NonNull ComponentInfo componentInfo, @NonNull Callable<NetworkChannelHandler> handlerFactory) {
        this(eventManager, componentInfo, handlerFactory, null);
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (componentInfo == null) {
            throw new NullPointerException("componentInfo is marked non-null but is null");
        }
        if (handlerFactory == null) {
            throw new NullPointerException("handlerFactory is marked non-null but is null");
        }
    }

    public NettyNetworkClient(@NonNull EventManager eventManager, @NonNull ComponentInfo componentInfo, @NonNull Callable<NetworkChannelHandler> handlerFactory, @Nullable SSLConfiguration sslConfiguration) {
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (componentInfo == null) {
            throw new NullPointerException("componentInfo is marked non-null but is null");
        }
        if (handlerFactory == null) {
            throw new NullPointerException("handlerFactory is marked non-null but is null");
        }
        this.eventManager = eventManager;
        this.handlerFactory = handlerFactory;
        this.sslConfiguration = sslConfiguration;
        this.packetDispatcher = NettyUtil.newPacketDispatcher(componentInfo.environment());
        try {
            this.init();
        }
        catch (Exception exception) {
            LOGGER.severe("Exception while initializing the netty network client", (Throwable)exception, new Object[0]);
        }
    }

    @Override
    public boolean sslEnabled() {
        return this.sslContext != null;
    }

    @Override
    @NonNull
    public Task<Void> connect(@NonNull HostAndPort hostAndPort) {
        if (hostAndPort == null) {
            throw new NullPointerException("hostAndPort is marked non-null but is null");
        }
        Task result = new Task();
        ((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channelFactory(NettyUtil.clientChannelFactory()).handler((ChannelHandler)new NettyNetworkClientInitializer(hostAndPort, this.eventManager, this).option(ChannelOption.IP_TOS, 24).option(ChannelOption.AUTO_READ, true).option(ChannelOption.TCP_NODELAY, true).option(ChannelOption.SO_REUSEADDR, true).option(ChannelOption.TCP_FASTOPEN_CONNECT, true).option(ChannelOption.WRITE_BUFFER_WATER_MARK, WATER_MARK).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 5000))).connect(hostAndPort.host(), hostAndPort.port()).addListener(future -> {
            if (future.isSuccess()) {
                result.complete(null);
            } else {
                result.completeExceptionally(future.cause());
            }
        });
        return result;
    }

    @Override
    public void close() {
        this.closeChannels();
        this.eventLoopGroup.shutdownGracefully();
    }

    @Override
    @NonNull
    public Collection<NetworkChannel> channels() {
        return Collections.unmodifiableCollection(this.channels);
    }

    @Override
    @NonNull
    public Executor packetDispatcher() {
        return this.packetDispatcher;
    }

    @Override
    @NonNull
    public Collection<NetworkChannel> modifiableChannels() {
        return this.channels;
    }

    @Override
    @NonNull
    public PacketListenerRegistry packetRegistry() {
        return this.packetRegistry;
    }

    private void init() throws Exception {
        block22: {
            if (this.sslConfiguration != null && this.sslConfiguration.enabled()) {
                if (this.sslConfiguration.certificatePath() != null && this.sslConfiguration.privateKeyPath() != null) {
                    SslContextBuilder builder = SslContextBuilder.forClient();
                    if (this.sslConfiguration.trustCertificatePath() != null) {
                        try (InputStream stream = Files.newInputStream(this.sslConfiguration.trustCertificatePath(), new OpenOption[0]);){
                            builder.trustManager(stream);
                        }
                    } else {
                        builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
                    }
                    try (InputStream cert = Files.newInputStream(this.sslConfiguration.certificatePath(), new OpenOption[0]);
                         InputStream privateKey = Files.newInputStream(this.sslConfiguration.privateKeyPath(), new OpenOption[0]);){
                        this.sslContext = builder.keyManager(cert, privateKey).clientAuth(this.sslConfiguration.clientAuth() ? ClientAuth.REQUIRE : ClientAuth.OPTIONAL).build();
                        break block22;
                    }
                }
                SelfSignedCertificate selfSignedCertificate = new SelfSignedCertificate();
                this.sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).keyManager(selfSignedCertificate.certificate(), selfSignedCertificate.privateKey()).build();
            }
        }
    }
}

