/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty.buffer;

import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.netty.NettyUtil;
import eu.cloudnetservice.driver.network.netty.buffer.NettyMutableDataBuf;
import eu.cloudnetservice.driver.network.rpc.defaults.object.DefaultObjectMapper;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAccessor;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.function.Function;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class NettyImmutableDataBuf
implements DataBuf {
    protected final Buffer buffer;
    protected boolean releasable;
    protected volatile int readOffset;
    protected volatile int writeOffset;

    public NettyImmutableDataBuf(@NonNull Buffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        this.buffer = buffer;
        this.enableReleasing();
    }

    @Override
    public boolean readBoolean() {
        return this.hotRead(BufferAccessor::readBoolean);
    }

    @Override
    public byte readByte() {
        return this.hotRead(BufferAccessor::readByte);
    }

    @Override
    public int readInt() {
        return this.hotRead(BufferAccessor::readInt);
    }

    @Override
    public short readShort() {
        return this.hotRead(BufferAccessor::readShort);
    }

    @Override
    public long readLong() {
        return this.hotRead(BufferAccessor::readLong);
    }

    @Override
    public float readFloat() {
        return this.hotRead(BufferAccessor::readFloat).floatValue();
    }

    @Override
    public double readDouble() {
        return this.hotRead(BufferAccessor::readDouble);
    }

    @Override
    public char readChar() {
        return this.hotRead(BufferAccessor::readChar).charValue();
    }

    @Override
    public byte[] readByteArray() {
        return this.hotRead(buf -> {
            byte[] bytes = new byte[NettyUtil.readVarInt(buf)];
            buf.readBytes(bytes, 0, bytes.length);
            return bytes;
        });
    }

    @Override
    @NonNull
    public UUID readUniqueId() {
        return new UUID(this.readLong(), this.readLong());
    }

    @Override
    @NonNull
    public String readString() {
        return this.hotRead(buf -> {
            int length = NettyUtil.readVarInt(buf);
            return buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
        });
    }

    @Override
    @NonNull
    public DataBuf readDataBuf() {
        return this.hotRead(buf -> {
            int length = buf.readInt();
            NettyImmutableDataBuf content = new NettyImmutableDataBuf(buf.copy(buf.readerOffset(), length, true));
            buf.skipReadableBytes(length);
            return content;
        });
    }

    @Override
    public byte[] toByteArray() {
        return this.hotRead(buf -> {
            byte[] bytes = new byte[buf.readableBytes()];
            buf.readBytes(bytes, 0, bytes.length);
            return bytes;
        });
    }

    @Override
    @Nullable
    public <T> T readObject(@NonNull Class<T> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return DefaultObjectMapper.DEFAULT_MAPPER.readObject(this, type);
    }

    @Override
    public <T> T readObject(@NonNull Type type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return DefaultObjectMapper.DEFAULT_MAPPER.readObject(this, type);
    }

    @Override
    @Nullable
    public <T> T readNullable(@NonNull Function<DataBuf, T> readerWhenNonNull) {
        if (readerWhenNonNull == null) {
            throw new NullPointerException("readerWhenNonNull is marked non-null but is null");
        }
        return this.readNullable(readerWhenNonNull, null);
    }

    @Override
    public <T> T readNullable(@NonNull Function<DataBuf, T> readerWhenNonNull, T valueWhenNull) {
        if (readerWhenNonNull == null) {
            throw new NullPointerException("readerWhenNonNull is marked non-null but is null");
        }
        return (T)this.hotRead(buf -> {
            boolean isNonNull = buf.readBoolean();
            return isNonNull ? readerWhenNonNull.apply(this) : valueWhenNull;
        });
    }

    @Override
    public int readableBytes() {
        return this.buffer.readableBytes();
    }

    @Override
    @NonNull
    public DataBuf startTransaction() {
        this.readOffset = this.buffer.readerOffset();
        this.writeOffset = this.buffer.writerOffset();
        return this;
    }

    @Override
    @NonNull
    public DataBuf redoTransaction() {
        this.buffer.readerOffset(this.readOffset);
        if (!this.buffer.readOnly()) {
            this.buffer.writerOffset(this.writeOffset);
        }
        return this;
    }

    @Override
    @NonNull
    public DataBuf.Mutable asMutable() {
        return this.buffer.readOnly() ? new NettyMutableDataBuf(this.buffer.copy()) : new NettyMutableDataBuf(this.buffer);
    }

    @Override
    public boolean accessible() {
        return this.buffer.isAccessible();
    }

    @Override
    @NonNull
    public DataBuf disableReleasing() {
        this.releasable = false;
        return this;
    }

    @Override
    @NonNull
    public DataBuf enableReleasing() {
        this.releasable = true;
        return this;
    }

    @Override
    public void release() {
        if (this.releasable && this.buffer.isAccessible()) {
            this.buffer.close();
        }
    }

    @Override
    public void close() {
        this.release();
    }

    @ApiStatus.Internal
    @NonNull
    public Buffer buffer() {
        return this.buffer;
    }

    @NonNull
    protected <T> T hotRead(@NonNull Function<Buffer, T> reader) {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        T result = reader.apply(this.buffer);
        if (this.buffer.readableBytes() <= 0) {
            this.release();
        }
        return result;
    }
}

