/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.http.annotation.parser;

import eu.cloudnetservice.driver.network.http.HttpContext;
import eu.cloudnetservice.driver.network.http.annotation.parser.ParameterInvocationHint;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiFunction;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class HttpAnnotationProcessorUtil {
    private HttpAnnotationProcessorUtil() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static <A extends Annotation> Collection<ParameterInvocationHint> mapParameters(@NonNull Method method, @NonNull Class<A> annotationType, @NonNull BiFunction<Parameter, A, BiFunction<String, HttpContext, Object>> mapper) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (annotationType == null) {
            throw new NullPointerException("annotationType is marked non-null but is null");
        }
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        Parameter[] parameters = method.getParameters();
        ArrayList<ParameterInvocationHint> hints = new ArrayList<ParameterInvocationHint>();
        for (int i = 0; i < parameters.length; ++i) {
            BiFunction<String, HttpContext, Object> valueResolver;
            Parameter param = parameters[i];
            A annotation = param.getAnnotation(annotationType);
            if (annotation == null || (valueResolver = mapper.apply(param, annotation)) == null) continue;
            hints.add(new ParameterInvocationHint(i, param, valueResolver));
        }
        return hints;
    }
}

